/*
 *             Automatically Tuned Linear Algebra Software v3.3.7
 **************** THIS IS AN UNSUPPORTED DEVELOPER RELEASE *****************
 *                    (C) Copyright 1999 R. Clint Whaley
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *   1. Redistributions of source code must retain the above copyright
 *      notice, this list of conditions and the following disclaimer.
 *   2. Redistributions in binary form must reproduce the above copyright
 *      notice, this list of conditions, and the following disclaimer in the
 *      documentation and/or other materials provided with the distribution.
 *   3. The name of the University of Tennessee, the ATLAS group,
 *      or the names of its contributers may not be used to endorse
 *      or promote products derived from this software without specific
 *      written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE UNIVERSITY OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

#ifndef ATLAS_LAPACK_H
   #define ATLAS_LAPACK_H

#include "atlas_misc.h"
#include "cblas.h"

#ifdef PATL

#include "atlas_cblastypealias.h"
/*
 * predefined type macro names
 */
#define ATL_trtri    Mjoin(PATL,trtri)
#define ATL_potrfU   Mjoin(PATL,potrfU)
#define ATL_potrfL   Mjoin(PATL,potrfL)
#define ATL_potrs    Mjoin(PATL,potrs)
#define ATL_potrf    Mjoin(PATL,potrf)
#define ATL_getrfR   Mjoin(PATL,getrfR)
#define ATL_getrfC   Mjoin(PATL,getrfC)
#define ATL_getrs    Mjoin(PATL,getrs)
#define ATL_getrf    Mjoin(PATL,getrf)
#define ATL_laswp    Mjoin(PATL,laswp)

#endif

int ATL_spotrf(const enum CBLAS_ORDER Order, const enum CBLAS_UPLO Uplo,
               const int N, float *A, const int lda);
void ATL_spotrs(const enum CBLAS_ORDER Order, const enum CBLAS_UPLO Uplo,
                const int N, const int NRHS, const float *A, const int lda,
                float *B, const int ldb);
int ATL_sgetrf(const enum CBLAS_ORDER Order, const int M, const int N,
               float *A, const int lda, int *ipiv);
void ATL_sgetrs(const enum CBLAS_ORDER Order, const enum CBLAS_TRANSPOSE Trans,
                const int N, const int NRHS, const float *A, const int lda,
                const int *ipiv, float *B, const int ldb);
void ATL_slaswp(const int N, float *A, const int lda0, const int K1,
               const int K2, const int *ipiv, const int inci);
int ATL_sgetrfC(const int M, const int N, float *A, const int lda,
                int *ipiv);
int ATL_sgetrfR(const int M, const int N, float *A, const int lda,
                int *ipiv);
int ATL_spotrfU(const int N, float *A, const int lda);
int ATL_spotrfL(const int N, float *A, const int lda);
int ATL_strtri(const enum CBLAS_ORDER Order, const enum CBLAS_UPLO Uplo,
               const enum CBLAS_DIAG Diag, const int N, float *A, const int lda);

int ATL_dpotrf(const enum CBLAS_ORDER Order, const enum CBLAS_UPLO Uplo,
               const int N, double *A, const int lda);
void ATL_dpotrs(const enum CBLAS_ORDER Order, const enum CBLAS_UPLO Uplo,
                const int N, const int NRHS, const double *A, const int lda,
                double *B, const int ldb);
int ATL_dgetrf(const enum CBLAS_ORDER Order, const int M, const int N,
               double *A, const int lda, int *ipiv);
void ATL_dgetrs(const enum CBLAS_ORDER Order, const enum CBLAS_TRANSPOSE Trans,
                const int N, const int NRHS, const double *A, const int lda,
                const int *ipiv, double *B, const int ldb);
void ATL_dlaswp(const int N, double *A, const int lda0, const int K1,
               const int K2, const int *ipiv, const int inci);
int ATL_dgetrfC(const int M, const int N, double *A, const int lda,
                int *ipiv);
int ATL_dgetrfR(const int M, const int N, double *A, const int lda,
                int *ipiv);
int ATL_dpotrfU(const int N, double *A, const int lda);
int ATL_dpotrfL(const int N, double *A, const int lda);
int ATL_dtrtri(const enum CBLAS_ORDER Order, const enum CBLAS_UPLO Uplo,
               const enum CBLAS_DIAG Diag, const int N, double *A, const int lda);

int ATL_cpotrf(const enum CBLAS_ORDER Order, const enum CBLAS_UPLO Uplo,
               const int N, float *A, const int lda);
void ATL_cpotrs(const enum CBLAS_ORDER Order, const enum CBLAS_UPLO Uplo,
                const int N, const int NRHS, const float *A, const int lda,
                float *B, const int ldb);
int ATL_cgetrf(const enum CBLAS_ORDER Order, const int M, const int N,
               float *A, const int lda, int *ipiv);
void ATL_cgetrs(const enum CBLAS_ORDER Order, const enum CBLAS_TRANSPOSE Trans,
                const int N, const int NRHS, const float *A, const int lda,
                const int *ipiv, float *B, const int ldb);
void ATL_claswp(const int N, float *A, const int lda0, const int K1,
               const int K2, const int *ipiv, const int inci);
int ATL_cgetrfC(const int M, const int N, float *A, const int lda,
                int *ipiv);
int ATL_cgetrfR(const int M, const int N, float *A, const int lda,
                int *ipiv);
int ATL_cpotrfU(const int N, float *A, const int lda);
int ATL_cpotrfL(const int N, float *A, const int lda);
int ATL_ctrtri(const enum CBLAS_ORDER Order, const enum CBLAS_UPLO Uplo,
               const enum CBLAS_DIAG Diag, const int N, float *A, const int lda);

int ATL_zpotrf(const enum CBLAS_ORDER Order, const enum CBLAS_UPLO Uplo,
               const int N, double *A, const int lda);
void ATL_zpotrs(const enum CBLAS_ORDER Order, const enum CBLAS_UPLO Uplo,
                const int N, const int NRHS, const double *A, const int lda,
                double *B, const int ldb);
int ATL_zgetrf(const enum CBLAS_ORDER Order, const int M, const int N,
               double *A, const int lda, int *ipiv);
void ATL_zgetrs(const enum CBLAS_ORDER Order, const enum CBLAS_TRANSPOSE Trans,
                const int N, const int NRHS, const double *A, const int lda,
                const int *ipiv, double *B, const int ldb);
void ATL_zlaswp(const int N, double *A, const int lda0, const int K1,
               const int K2, const int *ipiv, const int inci);
int ATL_zgetrfC(const int M, const int N, double *A, const int lda,
                int *ipiv);
int ATL_zgetrfR(const int M, const int N, double *A, const int lda,
                int *ipiv);
int ATL_zpotrfU(const int N, double *A, const int lda);
int ATL_zpotrfL(const int N, double *A, const int lda);
int ATL_ztrtri(const enum CBLAS_ORDER Order, const enum CBLAS_UPLO Uplo,
               const enum CBLAS_DIAG Diag, const int N, double *A, const int lda);

#endif










