#include "atlas_misc.h"
#include "atlas_prefetch.h"
#include <math.h>

#undef Mabs
/* #define Mabs(x) ( ((x) >= 0.0) ? (x) : -(x) ) */
#define Mabs fabs
int ATL_UIAMAX(const int N, const TYPE *X, const int incX)
{
   register TYPE xmax, x0, x1;
   const TYPE *stX=X+N, *x, *xp=X;
   int nr;
   if (N > 0)
   {
      xmax = *X;
      xmax = Mabs(xmax);
      nr = N-1;
      nr = nr - ((nr>>3)<<3);
      if (nr)
      {
         x = X+1;
         do
         {
            x0 = *x++;
            x0 = Mabs(x0);
            if (x0 > xmax) { xmax = x0; xp = x-1; };
         }
         while(--nr);
      }
      else x = X + 1;
      if (N > 8)
      {
         do
         {
            ATL_pfl1R(x+24);
            x0 = *x; x1 = x[1];
            x0 = Mabs(x0); x1 = Mabs(x1);
            if (xmax >= x0 && xmax >= x1) goto L1;
            else if (x0 >= x1) { xmax = x0; xp = x; }
            else { xmax = x1; xp = x + 1; }
L1:
            x0 = x[2]; x1 = x[3];
            x0 = Mabs(x0); x1 = Mabs(x1);
            if (xmax >= x0 && xmax >= x1) goto L2;
            else if (x0 >= x1) { xmax = x0; xp = x + 2; }
            else { xmax = x1; xp = x + 3; }
L2:
            x0 = x[4]; x1 = x[5];
            x0 = Mabs(x0); x1 = Mabs(x1);
            if (xmax >= x0 && xmax >= x1) goto L3;
            else if (x0 >= x1) { xmax = x0; xp = x + 4; }
            else { xmax = x1; xp = x + 5; }
L3:
            x0 = x[6]; x1 = x[7];
            x0 = Mabs(x0); x1 = Mabs(x1);
            if (xmax >= x0 && xmax >= x1) goto L4;
            else if (x0 >= x1) { xmax = x0; xp = x + 6; }
            else { xmax = x1; xp = x + 7; }
L4:
            x += 8;
         }
         while (x != stX);
      }
   }
   return((int)(xp-X));
}
