/*
 *             Automatically Tuned Linear Algebra Software v3.3.0Dev
 **************** THIS IS AN UNSUPPORTED DEVELOPER RELEASE *****************
 *                      (C) Copyright 1999 Camm Maguire                      
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *   1. Redistributions of source code must retain the above copyright
 *      notice, this list of conditions and the following disclaimer.
 *   2. Redistributions in binary form must reproduce the above copyright
 *      notice, this list of conditions, and the following disclaimer in the
 *      documentation and/or other materials provided with the distribution.
 *   3. The name of the University of Tennessee, the ATLAS group,
 *      or the names of its contributers may not be used to endorse
 *      or promote products derived from this software without specific
 *      written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE UNIVERSITY OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE. 
 *
 */
#include <stdio.h>
#include <stdlib.h>

#ifndef STRIDE
   #define STRIDE 1
#endif
#ifndef NDPM
   #define NDPM 2
#endif

#define Mjoin(a,b) mjoin(a,b)
#define mjoin(a,b) a ## b

#define EXT5 5g
#define EXT4 4g
#define EXT3 3g
#define EXT2 2g
#define EXT1 1g


#define NDP 5
#define EXT EXT5
#include "camm_ga.h"
#undef NDP
#define NDP 4
#undef EXT
#define EXT EXT4
#include "camm_ga.h"
#undef NDP
#define NDP 3
#undef EXT
#define EXT EXT3
#include "camm_ga.h"
#undef NDP
#define NDP 2
#undef EXT
#define EXT EXT2
#include "camm_ga.h"
#undef NDP
#define NDP 1
#undef EXT
#define EXT EXT1
#include "camm_ga.h"
#undef NDP

#define NDP NDPM
#undef EXT
#define EXT Mjoin(Mjoin(NDP,g),m)
#include "camm_ga.h"


void 
ATL_sger1_a1_x1_yX(int m,int n,float alpha,const float *c,int cinc,
		   const float *b,int binc,float *a,int lda) {


  int i,mm,nn;
  const float *ae;


  ae=a+n*lda;
  nn=STRIDE*lda;

#if NDPM == 1
  for (;a<ae;a+=lda,b+=binc)
    Mjoin(g,EXT)(b,STRIDE,a,nn,c,m);
#else

  while (a+NDPM*nn<=ae) {
    for (i=0;i<STRIDE;i++,a+=lda,b+=binc) 
      Mjoin(g,EXT)(b,STRIDE*binc,a,nn,c,m);

    a+=(NDPM-1)*nn;
    b+=(NDPM-1)*STRIDE*binc;
  }

  for (i=0;a<ae && i<STRIDE;i++,a+=lda,b+=binc) {

    mm=(ae-a)/nn;
    if (((ae-a)/lda)%STRIDE)
      mm++;
    
    if (mm == 1)
      Mjoin(g,EXT1)(b,STRIDE*binc,a,nn,c,m);

    else if (mm == 2)
      Mjoin(g,EXT2)(b,STRIDE*binc,a,nn,c,m);

    else if (mm == 3)
      Mjoin(g,EXT3)(b,STRIDE*binc,a,nn,c,m);

    else if (mm == 4)
      Mjoin(g,EXT4)(b,STRIDE*binc,a,nn,c,m);

    else if (mm == 5)
      Mjoin(g,EXT5)(b,STRIDE*binc,a,nn,c,m);

  }

#endif

}
