#include "atlas_misc.h"
#include <math.h>
TYPE ATL_UNRM2(const int N, const TYPE *X, const int incX)
{
   int i;
   const int incx = incX+incX;
   TYPE t0, ax, ssq=ATL_rone, scal=ATL_rzero;
   if (N > 0)
   {
      for (i=N; i; i--, X += incx)
      {
         ax = *X;
         if (ax != ATL_rzero)
         {
            ax = Mabs(ax);
            if (scal < ax)
            {
               t0 = scal / ax;
               t0 *= t0;
               scal = ax;
               ssq = ATL_rone + ssq * t0;
            }
            else
            {
               t0 = ax / scal;
               ssq += t0*t0;
            }
         }
         ax = X[1];
         if (ax != ATL_rzero)
         {
            ax = Mabs(ax);
            if (scal < ax)
            {
               t0 = scal / ax;
               t0 *= t0;
               scal = ax;
               ssq = ATL_rone + ssq * t0;
            }
            else
            {
               t0 = ax / scal;
               ssq += t0*t0;
            }
         }
      }
   }
   return(scal * sqrt(ssq));
}
