#include "atlas_misc.h"
#include <math.h>
TYPE ATL_UNRM2(const int N, const TYPE *X, const int incX)
{
   int i;
   TYPE ssq=ATL_rone, scal=ATL_rzero, ax, t0;

   for (i=N; i; i--, X += incX)
   {
      ax = *X;
      if (ax != ATL_rzero)
      {
         ax = fabs(ax);
         if (scal < ax)
         {
            t0 = scal / ax;
            t0 *= t0;
            ssq = ATL_rone + ssq * t0;
            scal = ax;
         }
         else
         {
            t0 = ax / scal;
            ssq += t0*t0;
         }
      }
   }
   return(scal * sqrt(ssq));
}
