#include "atlas_misc.h"
#include <math.h>

int ATL_UIAMAX(const int N, const TYPE *X, const int incX)
{
   register TYPE xmax, x0, x1, x2;
   const TYPE *stX=X+N, *x=X+1, *xp=X;
   int nr;
   if (N > 0)
   {
      xmax = *X;
      xmax = fabs(xmax);
      nr = N-1;
      nr = nr - (nr/12)*12;
      if (nr)
      {
         do
         {
            x0 = *x++;
            x0 = fabs(x0);
            if (x0 > xmax) { xmax = x0; xp = x-1; }
         }
         while(--nr);
      }
      if (N > 12)
      {
         do
         {
            x0 = *x; x1 = x[1]; x2 = x[2];
            x0 = fabs(x0); x1 = fabs(x1); x2 = fabs(x2);
            if (xmax >= x0 && xmax >= x1 && xmax >= x2) goto L2;
            else if (x0 >= x1 && x0 >= x2) { xmax = x0; xp = x; }
            else if (x1 >= x2) { xmax = x1; xp = x+1; }
            else { xmax = x2; xp = x+2; }

L2:         x0 = x[3]; x1 = x[4]; x2 = x[5];
            x0 = fabs(x0); x1 = fabs(x1); x2 = fabs(x2);
            if (xmax >= x0 && xmax >= x1 && xmax >= x2) goto L3;
            else if (x0 >= x1 && x0 >= x2) { xmax = x0; xp = x+3; }
            else if (x1 >= x2) { xmax = x1; xp = x+4; }
            else { xmax = x2; xp = x+5; }

L3:         x0 = x[6]; x1 = x[7]; x2 = x[8];
            x0 = fabs(x0); x1 = fabs(x1); x2 = fabs(x2);
            if (xmax >= x0 && xmax >= x1 && xmax >= x2) goto L4;
            else if (x0 >= x1 && x0 >= x2) { xmax = x0; xp = x+6; }
            else if (x1 >= x2) { xmax = x1; xp = x+7; }
            else { xmax = x2; xp = x+8; }

L4:         x0 = x[9]; x1 = x[10]; x2 = x[11]; x += 12;
            x0 = fabs(x0); x1 = fabs(x1); x2 = fabs(x2);
            if (xmax >= x0 && xmax >= x1 && xmax >= x2) continue;
            else if (x0 >= x1 && x0 >= x2) { xmax = x0; xp = x - 3; }
            else if (x1 >= x2) { xmax = x1; xp = x - 2; }
            else { xmax = x2; xp = x - 1; }
         }
         while (x != stX);
      }
   }
   return((int)(xp-X));
}
