#include "atlas_misc.h"
#include "atlas_prefetch.h"
#include <math.h>
/*

#define PREFETCH(x) \
__asm__ __volatile__ (" prefetcht0      %0": : "m"(*(char *)(x)))
#define PREFETCH1(x) \
__asm__ __volatile__ (" prefetcht0      %0": : "r"(x))

#undef ATL_pfl1R
#define ATL_pfl1R PREFETCH
*/

#undef Mabs
/* #define Mabs(x) ( ((x) >= 0.0) ? (x) : -(x) ) */
#define Mabs fabs
int bobmax(const int N, const TYPE *X, const int incX)
{
   register TYPE xmax, x0, x1;
   const TYPE *stX=X+N, *x, *xp=X, *xn;
   int nr;
   if (N > 0)
   {
      xmax = *X;
      xmax = Mabs(xmax);
      nr = N-1;
      nr = nr - ((nr>>2)<<2);
      if (nr)
      {
         x0 = X[1];
         x0 = Mabs(x0);
         if (x0 > xmax) { xmax = x0; xp = X + 1; };
         if (nr != 1)
         {
            x0 = X[2];
            x0 = fabs(x0);
            if (x0 > xmax) { xmax = x0; xp = X + 2; }
            if (nr == 3)
            {
               x0 = X[3];
               x0 = fabs(x0);
               if (x0 > xmax) { xmax = x0; xp = X + 3; }
               x = X + 4;
            }
            else x = X + 3;
         }
         else x = X + 2;
      }
      else x = X + 1;
      if (N > 4)
      {
         do
         {
/*         ATL_pfl1R((x+24)); */
         ATL_pfl1R((x+24)); 
            xn = x + 4;
            x0 = *x; x1 = x[1];
            x0 = Mabs(x0); x1 = Mabs(x1);
            if (xmax >= x0 && xmax >= x1) goto L1;
            else if (x0 >= x1) { xmax = x0; xp = x; }
            else { xmax = x1; xp = x + 1; }

L1:         x0 = x[2]; x1 = x[3];
            x0 = Mabs(x0); x1 = Mabs(x1);
            if (xmax >= x0 && xmax >= x1) goto L2;
            else if (x0 >= x1) { xmax = x0; xp = x + 2; }
            else { xmax = x1; xp = x + 3; }
L2:         x = xn;
         }
         while (x != stX);
      }
   }
   return((int)(xp-X));
}

int ATL_UIAMAX(const int N, const TYPE *X, const int incX)
{
   size_t jj, ii;
   TYPE val;
   int i, j;

   return(bobmax(N, X, 1));
#if 0
   jj = ii = (size_t) X;
   ii = ii - ((ii>>6)<<6);  
/*   ii = jj % 64; */
/* fprintf(stdout, "ii=%d, %d\n", ii, (jj+64-ii)%64); */
ii=0;
   if (!ii) return(bobmax(N, X, 1));
   ii = ii >> 3;
   ii = 8 - ii;
   i = bobmax(N-ii, X+ii, 1) + ii;
   val = fabs(X[i]);
   for (j=0; j < ii; j++)
      if (fabs(X[j]) >= val) {val = fabs(X[j]); i = j; }
   return(i);
#endif
}
