#include "atlas_misc.h"
#include "atlas_prefetch.h"

TYPE ATL_UDOT(const int N, const TYPE *X, const int incX, 
             const TYPE *Y, const int incY)
{
   register TYPE dot0=ATL_rzero, dot1=ATL_rzero, dot2=ATL_rzero, dot3=ATL_rzero;
   const TYPE *stX, *stX0=X+N;
   int i;
   stX = X + ((N>>2)<<2);
   if (X != stX)
   {
      do
      {
         ATL_pfl1R(X+80);
         dot0 += *X * *Y;
         dot1 += X[1] * Y[1];
         dot2 += X[2] * Y[2];
         dot3 += X[3] * Y[3];
         X += 4;
         Y += 4;
      }
      while (X != stX);
      dot0 += dot1;
      dot2 += dot3;
      dot0 += dot2;
   }
   while (X != stX0) dot0 += *X++ * *Y++;
   return(dot0);
}
