#include "atlas_misc.h"
#include "atlas_prefetch.h"

void ATL_UDOT(const int N, const TYPE *X, const int incx, 
              const TYPE *Y, const int incy, SCALAR dot)
{
   register TYPE rx, ix, ry, iy, rdot=ATL_rzero, idot=ATL_rzero;
   const int incX=incx+incx, incY=incy+incy;
   const TYPE *stX=X+((N>>1)<<2), *stX0 = X + N + N;
   if (X != stX)
   {
      do
      {
         ATL_pfl1R(X+48);
         ATL_pfl1R(Y+48);
         rx = *X; ix = X[1];
         ry = *Y; iy = Y[1];
         #ifndef Conj_
            rdot += rx*ry - ix*iy;
            idot += rx*iy + ix*ry;
         #else
            rdot += rx*ry + ix*iy;
            idot += rx*iy - ix*ry;
         #endif
         rx = X[2]; ix = X[3];
         ry = Y[2]; iy = Y[3];
         #ifndef Conj_
            rdot += rx*ry - ix*iy;
            idot += rx*iy + ix*ry;
         #else
            rdot += rx*ry + ix*iy;
            idot += rx*iy - ix*ry;
         #endif
         X += 4;
         Y += 4;
      }
      while (X != stX);
   }
   while (X != stX0)
   {
      rx = *X; ix = X[1];
      ry = *Y; iy = Y[1];
      #ifndef Conj_
         rdot += rx*ry - ix*iy;
         idot += rx*iy + ix*ry;
      #else
         rdot += rx*ry + ix*iy;
         idot += rx*iy - ix*ry;
      #endif
      X += 2; Y += 2;
   }
   dot[0] = rdot;
   dot[1] = idot;
}
