#include "atlas_misc.h"
#include "atlas_prefetch.h"
void ATL_UCOPY(const int N, const TYPE *X, const int incX,
               TYPE *Y, const int incY)
{
   int i;
   register TYPE x0, x1, x2, x3, x4, x5, x6, x7;
   x0 = *X; x1 = X[1]; x2 = X[2]; x3 = X[3];
   x4 = X[4]; x5 = X[5]; x6 = X[6]; x7 = X[7];
   for (i=((N-8)>>3); i; i--, Y += 8, X += 8)
   {
      *Y = x0;   x0 = X[8];
      Y[1] = x1; x1 = X[9];
      Y[2] = x2; x2 = X[10];
      Y[3] = x3; x3 = X[11];
      Y[4] = x4; x4 = X[12];
      Y[5] = x5; x5 = X[13];
      Y[6] = x6; x6 = X[14];
      Y[7] = x7; x7 = X[15];
   }
   for (i=N-(((N-8)>>3)<<3); i; i--) *Y++ = *X++;
}
