#include "atlas_misc.h"
#include "atlas_prefetch.h"
void ATL_UCOPY(const int N, const TYPE *X, const int incX,
               TYPE *Y, const int incY)
{
   int i;
   register TYPE x0, x1, x2, x3, x4, x5, x6, x7;
   register TYPE x8, x9, x10, x11, x12, x13, x14, x15;
   x0 = *X; x1 = X[1]; x2 = X[2]; x3 = X[3];
   x4 = X[4]; x5 = X[5]; x6 = X[6]; x7 = X[7];
   x8 = X[8]; x9 = X[9]; x10 = X[10]; x11 = X[11];
   x12 = X[12]; x13 = X[13]; x14 = X[14]; x15 = X[15];
   for (i=(N>>4)-1; i; i--, Y += 16, X += 16)
   {
      *Y    = x0;   x0 = X[16];
      Y[1]  = x1;  x1 = X[17];
      Y[2]  = x2;  x2 = X[18];
      Y[3]  = x3;  x3 = X[19];
      Y[4]  = x4;  x4 = X[20];
      Y[5]  = x5;  x5 = X[21];
      Y[6]  = x6;  x6 = X[22];
      Y[7]  = x7;  x7 = X[23];
      Y[8]  = x8;  x8 = X[24];
      Y[9]  = x9;  x9 = X[25];
      Y[10] = x10; x10 = X[26];
      Y[11] = x11; x11 = X[27];
      Y[12] = x12; x12 = X[28];
      Y[13] = x13; x13 = X[29];
      Y[14] = x14; x14 = X[30];
      Y[15] = x15; x15 = X[31];
   }
   for (i=N-((N>>4)<<4)+16; i; i--) *Y++ = *X++; 
}
