#include "atlas_misc.h"
#include "atlas_prefetch.h"
void ATL_UCOPY(const int N, const TYPE *X, const int incX,
               TYPE *Y, const int incY)
{
   int i;
   register TYPE x0, x1, x2, x3;
   x0 = *X; x1 = X[1]; x2 = X[2]; x3 = X[3];
   for (i=((N-4)>>2); i; i--, Y += 4, X += 4)
   {
      ATL_pfl1R(X+32);
      *Y = x0;   x0 = X[4];
      Y[1] = x1; x1 = X[5];
      Y[2] = x2; x2 = X[6];
      Y[3] = x3; x3 = X[7];
   }
   for (i=N-(((N-4)>>3)<<3); i; i--) *Y++ = *X++;
}
