/*
 *             Automatically Tuned Linear Algebra Software v3.3.0Dev
 **************** THIS IS AN UNSUPPORTED DEVELOPER RELEASE *****************
 *                    (C) Copyright 1999 R. Clint Whaley                     
 *
 * Code contributers : R. Clint Whaley, Antoine P. Petitet
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *   1. Redistributions of source code must retain the above copyright
 *      notice, this list of conditions and the following disclaimer.
 *   2. Redistributions in binary form must reproduce the above copyright
 *      notice, this list of conditions, and the following disclaimer in the
 *      documentation and/or other materials provided with the distribution.
 *   3. The name of the University of Tennessee, the ATLAS group,
 *      or the names of its contributers may not be used to endorse
 *      or promote products derived from this software without specific
 *      written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE UNIVERSITY OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE. 
 *
 */

#ifndef F77WRAP_LAPACK_H
#define F77WRAP_LAPACK_H

#include "atlas_misc.h"
#include "atlas_f77.h"

#ifdef UpCase
   #define PFW Mjoin(ATL_F77WRAP_,PREU)
#else
   #define PFW Mjoin(atl_f77wrap_,PRE)
#endif

#ifdef Add_
   #define F77WRAP_GETNB Mjoin(PFW,getnb_)
   #define F77WRAP_GETRS Mjoin(PFW,getrs_)
   #define F77WRAP_GETRF Mjoin(PFW,getrf_)
   #define F77WRAP_GESV Mjoin(PFW,gesv_)
   #define F77WRAP_POTRS Mjoin(PFW,potrs_)
   #define F77WRAP_POTRF Mjoin(PFW,potrf_)
   #define F77WRAP_POSV Mjoin(PFW,posv_)
#elif defined(Add__)
   #define F77WRAP_GETNB Mjoin(PFW,getnb__)
   #define F77WRAP_GETRS Mjoin(PFW,getrs__)
   #define F77WRAP_GETRF Mjoin(PFW,getrf__)
   #define F77WRAP_GESV Mjoin(PFW,gesv__)
   #define F77WRAP_POTRS Mjoin(PFW,potrs__)
   #define F77WRAP_POTRF Mjoin(PFW,potrf__)
   #define F77WRAP_POSV Mjoin(PFW,posv__)
#elif defined(NoChange)
   #define F77WRAP_GETNB Mjoin(PFW,getnb)
   #define F77WRAP_GETRS Mjoin(PFW,getrs)
   #define F77WRAP_GETRF Mjoin(PFW,getrf)
   #define F77WRAP_GESV Mjoin(PFW,gesv)
   #define F77WRAP_POTRS Mjoin(PFW,potrs)
   #define F77WRAP_POTRF Mjoin(PFW,potrf)
   #define F77WRAP_POSV Mjoin(PFW,posv)
#elif defined(UpCase)
   #define F77WRAP_GETNB Mjoin(PFW,GETNB)
   #define F77WRAP_GETRS Mjoin(PFW,GETRS)
   #define F77WRAP_GETRF Mjoin(PFW,GETRF)
   #define F77WRAP_GESV Mjoin(PFW,GESV)
   #define F77WRAP_POTRS Mjoin(PFW,POTRS)
   #define F77WRAP_POTRF Mjoin(PFW,POTRF)
   #define F77WRAP_POSV Mjoin(PFW,POSV)
#endif

#endif
