#ifndef ATLAS_PREFETCH_H
#define ATLAS_PREFETCH_H
/*
 * This macro depends on using some sort of GNU assembler. 
 * If you need support for other assemblers, this is the only 
 * macro to change. 
 */
 /* SSE prefetch is available */
#define ATL_GOT_L1PREFETCH
#if defined(ATL_SSE1) || defined (ATL_SSE2)
   #define ATL_pfl1R(mem) \
      __asm__ __volatile__ ("prefetcht0 %0" : : "m" (*((char *)(mem))))
   #define ATL_pfl1W(mem) \
      __asm__ __volatile__ ("prefetcht0 %0" : : "m" (*((char *)(mem))))
#elif defined(ATL_3DNow1) || defined(ATL_3DNow2)
   #define ATL_pfl1R(mem) \
      __asm__ __volatile__ ("prefetch %0" : : "m" (*((char *)(mem))))
   #define ATL_pfl1W(mem) \
      __asm__ __volatile__ ("prefetchtw %0" : : "m" (*((char *)(mem))))
#elif defined(ATL_IA64)
   #define ATL_pfl1R(mem) \
      __asm__ ("    lfetch  [%0]": : "r"((void *)(mem)))
   #define ATL_pfl1W(mem) \
      __asm__ ("    lfetch.excl     [%0]": : "r"((void *)(mem)))
#else
   #define ATL_pfl1R(mem) 
   #define ATL_pfl1W(mem)
   #undef ATL_GOT_L1PREFETCH
#endif

#endif
