/*
 *             Automatically Tuned Linear Algebra Software v3.3.0Dev
 **************** THIS IS AN UNSUPPORTED DEVELOPER RELEASE *****************
 *                    (C) Copyright 1999 R. Clint Whaley                     
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *   1. Redistributions of source code must retain the above copyright
 *      notice, this list of conditions and the following disclaimer.
 *   2. Redistributions in binary form must reproduce the above copyright
 *      notice, this list of conditions, and the following disclaimer in the
 *      documentation and/or other materials provided with the distribution.
 *   3. The name of the University of Tennessee, the ATLAS group,
 *      or the names of its contributers may not be used to endorse
 *      or promote products derived from this software without specific
 *      written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE UNIVERSITY OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE. 
 *
 */

#include "atlas_misc.h"
#include "atlas_lapack.h"

void ATL_getrs(const enum CBLAS_ORDER Order, const enum CBLAS_TRANSPOSE Trans,
               const int N, const int NRHS, const TYPE *A, const int lda, 
               const int *ipiv, TYPE *B, const int ldb)
{
   enum CBLAS_DIAG Lunit, Uunit;
   #ifdef TREAL
      #define one ATL_rone
   #else
      const TYPE one[2] = {ATL_rone, ATL_rzero};
   #endif

   if (!N || !NRHS) return;
   if (Order == CblasColMajor)
   {
      Lunit = CblasUnit;
      Uunit = CblasNonUnit;
   }
   else
   {
      Lunit = CblasNonUnit;
      Uunit = CblasUnit;
   }
/*
 * Solve A*X = B  ==> (trans(P)*L*U)*X = B ==> X = inv(U)*inv(L)*P*B
 */
   if (Trans == CblasNoTrans)
   {
      ATL_laswp(NRHS, B, ldb, 0, N, ipiv, 1);
      cblas_trsm(Order, CblasLeft, CblasLower, CblasNoTrans, Lunit,
                 N, NRHS, one, A, lda, B, ldb);
      cblas_trsm(Order, CblasLeft, CblasUpper, CblasNoTrans, Uunit,
                 N, NRHS, one, A, lda, B, ldb);
   }
/*
 *  A'*X = B   ==>   X = inv(P)*inv(L')*inv(U')*B
 */
   else
   {
      cblas_trsm(Order, CblasLeft, CblasUpper, Trans, Uunit, N, NRHS, one,
                 A, lda, B, ldb);
      cblas_trsm(Order, CblasLeft, CblasLower, Trans, Lunit, N, NRHS, one,
                 A, lda, B, ldb);
      ATL_laswp(NRHS, B, ldb, 0, N, ipiv, -1);
   }
}
