/*
 *             Automatically Tuned Linear Algebra Software v3.4.0
 *                    (C) Copyright 1997 R. Clint Whaley
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *   1. Redistributions of source code must retain the above copyright
 *      notice, this list of conditions and the following disclaimer.
 *   2. Redistributions in binary form must reproduce the above copyright
 *      notice, this list of conditions, and the following disclaimer in the
 *      documentation and/or other materials provided with the distribution.
 *   3. The name of the ATLAS group or the names of its contributers may
 *      not be used to endorse or promote products derived from this
 *      software without specific written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE ATLAS GROUP OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

#ifdef PentiumCPS  /* this code supplied by Phil Mucci */
   #include <sys/time.h>
   #include <sys/types.h>
   #include <stdlib.h>
   #include <stdio.h>

   static const int CPS = (PentiumCPS*1E6);
   static unsigned usec, sec;
   static unsigned tusec, tsec;
   static unsigned start=0, startu;
   static long long foo;

   static inline void microtime(unsigned *lo, unsigned *hi)
   {
     __asm __volatile (
           ".byte 0x0f; .byte 0x31   # RDTSC instruction
           movl    %%edx,%0          # High order 32 bits
           movl    %%eax,%1          # Low order 32 bits"
                   : "=g" (*hi), "=g" (*lo) :: "eax", "edx");
   }

   double ATL_walltime(void)
   {
     if (!start)
     {
        microtime(&startu, &start);
        return(0.0);
     }
     microtime(&usec, &sec);

     foo = sec;
     foo -= start;
     foo = (foo << 32) + usec;
     foo -= startu;
     return(((double)foo)/(double)CPS);
   }
#elif defined(UseTimes)
   #include <stdlib.h>
   #include <sys/times.h>
   #include <unistd.h>
   double ATL_walltime(void)
   {
      struct tms ts;
      static double ClockTick=0.0;

      if (ClockTick == 0.0) ClockTick = (double) sysconf(_SC_CLK_TCK);
      return( ((double) times(&ts)) / ClockTick);
   }
#elif defined(SUN_HR) /* use sun high resolution timers */
   #include <sys/time.h>
   double ATL_walltime(void)
   {
      return(gethrtime()*1.0e-9);
   }
#else
   #include <stdlib.h>
   #include <sys/time.h>
   #include <sys/resource.h>
   double ATL_walltime(void)
   {
      struct timeval tp;
      static long start=0, startu;
      if (!start)
      {
         gettimeofday(&tp, NULL);
         start = tp.tv_sec;
         startu = tp.tv_usec;
         return(0.0);
      }
      gettimeofday(&tp, NULL);
      return( ((double) (tp.tv_sec - start)) + (tp.tv_usec-startu)/1000000.0 );
   }
#endif

