      PROGRAM ZQCBY(INPUT,OUTPUT,TAPE7=OUTPUT)
C
C                 *** A DOUBLE PRECISION ROUTINE ***
C
C     ZQCBY IS A QUICK CHECK ROUTINE FOR THE COMPLEX Y BESSEL FUNCTION
C     GENERATED BY SUBROUTINE ZBESY.
C
C     ZQCBY GENERATES SEQUENCES OF Y BESSEL FUNCTIONS FROM
C     ZBESY AND CHECKS THEM AGAINST THE EVALUATION FROM THE FORMULA
C
C      Y(FNU,Z*ROT) = C(FNU+1)*I(FNU,Z)-(2/PI)*CONJG(C(FNU))*K(FNU,Z)
C           ROT=CEXP(PI*I/2) , C(FNU)=CEXP(PI*FNU*I/2) , I**2=-1
C                        -PI.LT.ARG(Z).LE.PI/2
C
C     IN THE (Z,FNU) SPACE.
C
C     MACHINE CONSTANTS ARE DEFINED IN FUNCTIONS I1MACH, R1MACH, AND
C     D1MACH. THESE MUST BE SELECTED BY THE USER OR SET ACCORDING TO
C     PROLOGUE INSTRUCTIONS.
C
C     COMPLEX CI,CIP,COE1,COE2,CSGN,CSPN,CW,CWRK,V,W,Y,Z,ZN
      DOUBLE PRECISION AA, AER, AI, ALIM, AR, ARG, ATOL, AV, C, CC,
     * CIPI, CIPR, COE1I, COE1R, COE2I, COE2R, CSGNI, CSGNR, CSPNI,
     * CSPNR, CWI, CWR, CWRKI, CWRKR, C1, DIG, ELIM, EPS, ER, ERTOL,
     * FAC, FFNU, FNU, FNUL, HPI, PI, PTR, R, RHPI, RL, RM, R1M5, R2,
     * S, SEPS, STI, STR, S1, T, TOL, TPI, VI, VR, WI, WR, XNU, YI, YR,
     * ZI, ZNI, ZNR, ZR, D1MACH, ZABS
      INTEGER I, IA, ICASE, IFNU, IL, IR, IRB, IT, ITL, I4, K, KK,
     * KODE, K1, K2, LFLG, LUN, MFLG, N, NU, NZ, NZ1, NZ2, IERR, I1MACH
      DIMENSION C(25), S(25), AER(25), XNU(7), YR(20), YI(20), WR(20),
     * WI(20), VR(20), VI(20), CIPR(4), CIPI(4), CWRKR(20), CWRKI(20)
      DATA CIPR(1), CIPI(1), CIPR(2), CIPI(2), CIPR(3), CIPI(3),
     * CIPR(4), CIPI(4) /1.0D0,0.0D0,0.0D0,1.0D0,-1.0D0,0.0D0,0.0D0,
     * -1.0D0/
      DATA LUN /7/
C-----------------------------------------------------------------------
C     SET PARAMETERS RELATED TO MACHINE CONSTANTS.
C     TOL IS THE APPROXIMATE UNIT ROUNDOFF LIMITED TO 1.0E-18.
C     ELIM IS THE APPROXIMATE EXPONENTIAL OVER- AND UNDERFLOW LIMIT.
C     EXP(-ELIM).LT.EXP(-ALIM)=EXP(-ELIM)/TOL    AND
C     EXP(ELIM).GT.EXP(ALIM)=EXP(ELIM)*TOL       ARE INTERVALS NEAR
C     UNDERFLOW AND OVERFLOW LIMITS WHERE SCALED ARITHMETIC IS DONE.
C     RL IS THE LOWER BOUNDARY OF THE ASYMPTOTIC EXPANSION FOR LARGE Z.
C     DIG = NUMBER OF BASE 10 DIGITS IN TOL = 10**(-DIG).
C     FNUL IS THE LOWER BOUNDARY OF THE ASYMPTOTIC SERIES FOR LARGE FNU
C-----------------------------------------------------------------------
      TOL = DMAX1(D1MACH(4),1.0D-18)
      K1 = I1MACH(15)
      K2 = I1MACH(16)
      R1M5 = D1MACH(5)
      K = MIN0(IABS(K1),IABS(K2))
      ELIM = 2.303D0*(DBLE(FLOAT(K))*R1M5-3.0D0)
      K1 = I1MACH(14) - 1
      AA = R1M5*DBLE(FLOAT(K1))
      DIG = DMIN1(AA,18.0D0)
      AA = AA*2.303D0
      ALIM = ELIM + DMAX1(-AA,-41.45D0)
      FNUL = 10.0D0 + 6.0D0*(DIG-3.0D0)
      RL = 1.2D0*DIG + 3.0D0
      RM = 0.5D0*(ALIM+ELIM)
      RM=DMIN1(RM,650.0D0)
      R2 = DMIN1(RM,FNUL)
C-----------------------------------------------------------------------
      WRITE (LUN,99999)
99999 FORMAT (54H QUICK CHECK ROUTINE FOR THE Y BESSEL FUNCTION FROM ZB,
     * 3HESY/)
      WRITE (LUN,99998)
99998 FORMAT (37H PARAMETERS TOL,ELIM,ALIM,RL,FNUL,DIG)
      WRITE (LUN,99997) TOL, ELIM, ALIM, RL, FNUL, DIG
99997 FORMAT (6D12.4/)
      ERTOL = TOL*1.0D+5
      FAC = 100.0D0
      ATOL = FAC*TOL
      HPI = 2.0D0*DATAN(1.0D0)
      RHPI = 1.0D0/HPI
      PI = HPI + HPI
      TPI = PI + PI
      I = 1
      IA = 4
      EPS = 0.01D0
      SEPS = EPS
      IL = 13
C-----------------------------------------------------------------------
C     TEST 13 VALUES OF Z IN -PI/2.LT.ARG(Z).LE.PI
C-----------------------------------------------------------------------
      WRITE (LUN,99996)
99996 FORMAT (/28H CHECKS IN THE (Z,FNU) SPACE/)
      DO 40 K=1,IL
        IF (K.NE.7) GO TO 10
        IA = 10
        SEPS = -SEPS
   10   CONTINUE
        IF (IABS(K-IA).EQ.2) GO TO 40
        T = -PI + TPI*DBLE(FLOAT(K-1))/DBLE(FLOAT(IL-1))
        C1 = DCOS(T)
        S1 = DSIN(T)
        IF (DABS(C1).LT.ATOL) C1 = 0.0D0
        IF (DABS(S1).LT.ATOL) S1 = 0.0D0
        C(I) = C1
        S(I) = S1
        IF (IABS(K-IA).GT.1) GO TO 30
        IF (IABS(K-IA).EQ.1) GO TO 20
        C(I) = C1 - SEPS
        S(I) = S1
        C(I+1) = C1
        S(I+1) = S1
        C(I+2) = C1 + SEPS
        S(I+2) = S1
        I = I + 3
        GO TO 40
   20   CONTINUE
        C(I) = C1 - SEPS
        S(I) = S1
        C(I+1) = C1 + SEPS
        S(I+1) = S1
        I = I + 2
        GO TO 40
   30   CONTINUE
        I = I + 1
   40 CONTINUE
      S(1) = -EPS
      ITL = I - 1
      XNU(1) = 0.0D0
      XNU(2) = 0.3D0
      XNU(3) = 0.7D0
      XNU(4) = 1.0D0
      XNU(5) = 1.3D0
      XNU(6) = 1.7D0
      XNU(7) = FNUL + 1.1D0
      LFLG = 0
      DO 190 KODE=1,2
        DO 180 N=1,4
          DO 170 NU=1,7
            FNU = XNU(NU)
            IFNU = INT(SNGL(FNU))
            FFNU = FNU - DBLE(FLOAT(IFNU))
            ARG = HPI*FFNU
            CSGNR = DCOS(ARG)
            CSGNI = DSIN(ARG)
            I4 = MOD(IFNU,4) + 1
            STR = CSGNR*CIPR(I4) - CSGNI*CIPI(I4)
            CSGNI = CSGNR*CIPI(I4) + CSGNI*CIPR(I4)
            CSGNR = STR
            CSPNR = CSGNR*RHPI
            CSPNI = -CSGNI*RHPI
            STR = -CSGNI
            CSGNI = CSGNR
            CSGNR = STR
            DO 160 ICASE=1,3
              IRB = MIN0(2,ICASE)
              DO 150 IR=IRB,4
                GO TO (50, 60, 70), ICASE
   50           CONTINUE
                R = (EPS*DBLE(FLOAT(4-IR))+2.0D0*DBLE(FLOAT(IR-1)))/
     *           3.0D0
                GO TO 80
   60           CONTINUE
                R = (2.0D0*DBLE(FLOAT(4-IR))+R2*DBLE(FLOAT(IR-1)))/3.0D0
                GO TO 80
   70           CONTINUE
                IF (RM.EQ.R2) GO TO 160
                R = (R2*DBLE(FLOAT(4-IR))+RM*DBLE(FLOAT(IR-1)))/3.0D0
   80           CONTINUE
                DO 140 IT=1,13
                  ZR = R*C(IT)
                  ZI = R*S(IT)
                  CALL ZBESI(ZR, ZI, FNU, KODE, N, WR, WI, NZ2, IERR)
                  IF (NZ2.NE.0) GO TO 140
                  CALL ZBESK(ZR, ZI, FNU, KODE, N, YR, YI, NZ1, IERR)
                  IF (NZ1.NE.0) GO TO 140
                  ZNR = -ZI
                  ZNI = ZR
                  CALL ZBESY(ZNR, ZNI, FNU, KODE, N, VR, VI, NZ, CWRKR,
     *             CWRKI, IERR)
                  IF (NZ.NE.0) GO TO 140
                  COE1R = CSGNR
                  COE1I = CSGNI
                  COE2R = CSPNR
                  COE2I = CSPNI
                  IF (KODE.EQ.1) GO TO 100
C-----------------------------------------------------------------------
C     SCALING ADJUSTMENTS IN I AND K FUNCTIONS FOR KODE=2
C-----------------------------------------------------------------------
                  CC = -ZR - DABS(ZR)
                  IF (CC.GT.(-ALIM)) GO TO 90
                  COE2R = 0.0D0
                  COE2I = 0.0D0
                  GO TO 140
   90             CONTINUE
                  ZNR = CC
                  ZNI = -ZI
                  CALL ZEXP(ZNR, ZNI, STR, STI)
                  PTR = STR*COE2R - STI*COE2I
                  COE2I = STR*COE2I + STI*COE2R
                  COE2R = PTR
  100             CONTINUE
                  DO 110 KK=1,N
                    STR = YR(KK)*COE2R - YI(KK)*COE2I
                    YI(KK) = YR(KK)*COE2I + YI(KK)*COE2R
                    YR(KK) = STR
                    STR = WR(KK)*COE1R - WI(KK)*COE1I
                    WI(KK) = WR(KK)*COE1I + WI(KK)*COE1R
                    WR(KK) = STR
                    STR = -COE1I
                    COE1I = COE1R
                    COE1R = STR
                    STR = COE2I
                    COE2I = -COE2R
                    COE2R = STR
  110             CONTINUE
                  MFLG = 0
                  DO 120 I=1,N
                    CWR = WR(I) - YR(I)
                    CWI = WI(I) - YI(I)
                    AV = ZABS(VR(I),VI(I))
                    AR = CWR - VR(I)
                    AI = CWI - VI(I)
                    ER = ZABS(AR,AI)/AV
                    AER(I) = ER
                    IF (ER.GT.ERTOL) MFLG = 1
  120             CONTINUE
                  IF (MFLG.EQ.0) GO TO 140
                  IF (LFLG.EQ.1) GO TO 130
                  WRITE (LUN,99995) ERTOL
99995             FORMAT (/41H CASES WHICH VIOLATE THE RELATIVE ERROR T,
     *             19HEST WITH ERTOL   = , D12.4/)
                  WRITE (LUN,99994)
99994             FORMAT (/14H OUTPUT FORMAT/23H KODE,N,IR,IT,NZ1,NZ2,I,
     *             4HCASE)
                  WRITE (LUN,99993)
99993             FORMAT (12H ER(K),K=1,N/26H Z,FNU,Y(KK),W(KK),V(KK), ,
     *             35HKK=INDEX OF FIRST NON-ZERO Y,W PAIR/)
                  LFLG = 1
  130             CONTINUE
                  KK = MAX0(NZ1,NZ2) + 1
                  KK = MIN0(N,KK)
                  WRITE (LUN,99992) KODE, N, IR, IT, NZ1, NZ2, ICASE
99992             FORMAT (8I5)
                  WRITE (LUN,99991) (AER(K),K=1,N)
                  WRITE (LUN,99991) ZR, ZI, FNU, YR(KK), YI(KK),
     *             WR(KK), WI(KK), VR(KK), VI(KK)
99991             FORMAT (9D12.4)
  140           CONTINUE
  150         CONTINUE
  160       CONTINUE
  170     CONTINUE
  180   CONTINUE
  190 CONTINUE
      IF (LFLG.EQ.0) WRITE (LUN,99990)
99990 FORMAT (/16H QUICK CHECKS OK/)
      STOP
      END
