      PROGRAM ZQCBJ(INPUT,OUTPUT,TAPE7=OUTPUT)
C
C                 *** A DOUBLE PRECISION ROUTINE ***
C
C     ZQCBJ IS A QUICK CHECK ROUTINE FOR THE COMPLEX J BESSEL FUNCTION
C     GENERATED BY SUBROUTINE ZBESJ.
C
C     ZQCBJ GENERATES SEQUENCES OF J BESSEL FUNCTIONS FROM
C     ZBESJ AND CHECKS THEM AGAINST THE EVALUATION FROM THE FORMULA
C
C               J(FNU,Z)=0.5*( H(1,FNU,Z) + H(2,FNU,Z) )
C                       -PI.LT.ARG(Z).LE.PI
C
C     FOR CABS(Z).GE.FNU. FOR CABS(Z).LT.FNU, THE FIRST N MEMBERS OF
C     A SEQUENCE OF LENGTH N+16 ARE CHECKED AGAINST A CORRESPONDING N
C     MEMBER SEQUENCE WHERE BOTH SEQUENCES ARE GENERATED BY ZBESJ
C     BEGINNING AT ORDER FNU.
C
C     MACHINE CONSTANTS ARE DEFINED IN FUNCTIONS I1MACH, R1MACH, AND
C     D1MACH. THESE MUST BE SELECTED BY THE USER OR SET ACCORDING TO
C     PROLOGUE INSTRUCTIONS.
C
C     COMPLEX CHALF,COE1,COE2,CW,V,W,Y,Z,ZN
      DOUBLE PRECISION AA, AER, AI, ALIM, AR, ATOL, AV, C, CC, COE1I,
     * COE1R, COE2I, COE2R, CWI, CWR, C1, DD, DIG, ELIM, EPS, ER,
     * ERTOL, FAC, FNU, FNUL, GNU, HALFI, HALFR, HPI, PI, R, RL, RM,
     * R1M5, R2, S, SEPS, STR, S1, T, TOL, TPI, VI, VR, WI, WR, XNU,
     * YI, YR, ZI, ZR, D1MACH, ZABS
      INTEGER I, IA, ICASE, IL, IR, IRB, IT, ITL, K, KK, KODE, K1, K2,
     * LFLG, LUN, M, MFLG, N, NU, NZ, NZ1, NZ2, I1MACH
      DIMENSION C(25), S(25), AER(25), XNU(7), YR(20), YI(20), WR(20),
     * WI(20), VR(20), VI(20)
      DATA LUN /7/
C-----------------------------------------------------------------------
C     SET PARAMETERS RELATED TO MACHINE CONSTANTS.
C     TOL IS THE APPROXIMATE UNIT ROUNDOFF LIMITED TO 1.0E-18.
C     ELIM IS THE APPROXIMATE EXPONENTIAL OVER- AND UNDERFLOW LIMIT.
C     EXP(-ELIM).LT.EXP(-ALIM)=EXP(-ELIM)/TOL    AND
C     EXP(ELIM).GT.EXP(ALIM)=EXP(ELIM)*TOL       ARE INTERVALS NEAR
C     UNDERFLOW AND OVERFLOW LIMITS WHERE SCALED ARITHMETIC IS DONE.
C     RL IS THE LOWER BOUNDARY OF THE ASYMPTOTIC EXPANSION FOR LARGE Z.
C     DIG = NUMBER OF BASE 10 DIGITS IN TOL = 10**(-DIG).
C     FNUL IS THE LOWER BOUNDARY OF THE ASYMPTOTIC SERIES FOR LARGE FNU
C-----------------------------------------------------------------------
      TOL = DMAX1(D1MACH(4),1.0D-18)
      K1 = I1MACH(15)
      K2 = I1MACH(16)
      R1M5 = D1MACH(5)
      K = MIN0(IABS(K1),IABS(K2))
      ELIM = 2.303D0*(DBLE(FLOAT(K))*R1M5-3.0D0)
      K1 = I1MACH(14) - 1
      AA = R1M5*DBLE(FLOAT(K1))
      DIG = DMIN1(AA,18.0D0)
      AA = AA*2.303D0
      ALIM = ELIM + DMAX1(-AA,-41.45D0)
      FNUL = 10.0D0 + 6.0D0*(DIG-3.0D0)
      RL = 1.2D0*DIG + 3.0D0
      RM = 0.5D0*(ALIM+ELIM)
      RM=DMIN1(RM,650.0D0)
      R2 = DMIN1(RM,FNUL)
C-----------------------------------------------------------------------
      WRITE (LUN,99999)
99999 FORMAT (54H QUICK CHECK ROUTINE FOR THE J BESSEL FUNCTION FROM ZB,
     * 3HESJ/)
      WRITE (LUN,99998)
99998 FORMAT (37H PARAMETERS TOL,ELIM,ALIM,RL,FNUL,DIG)
      WRITE (LUN,99997) TOL, ELIM, ALIM, RL, FNUL, DIG
99997 FORMAT (6D12.4/)
      ERTOL = TOL*1.0D+5
      HALFR = 0.5D0
      HALFI = 0.0D0
      FAC = 100.0D0
      ATOL = FAC*TOL
      HPI = 2.0D0*DATAN(1.0D0)
      PI = HPI + HPI
      TPI = PI + PI
      I = 1
      IA = 4
      EPS = 0.01D0
      SEPS = EPS
      IL = 13
C-----------------------------------------------------------------------
C     TEST 17 VALUES OF Z IN -PI.LT.ARG(Z).LE.PI
C-----------------------------------------------------------------------
      WRITE (LUN,99996)
99996 FORMAT (/28H CHECKS IN THE (Z,FNU) SPACE/)
      DO 40 K=1,IL
        IF (K.NE.7) GO TO 10
        IA = 10
        SEPS = -SEPS
   10   CONTINUE
        IF (IABS(K-IA).EQ.2) GO TO 40
        T = -PI + TPI*DBLE(FLOAT(K-1))/DBLE(FLOAT(IL-1))
        C1 = DCOS(T)
        S1 = DSIN(T)
        IF (DABS(C1).LT.ATOL) C1 = 0.0D0
        IF (DABS(S1).LT.ATOL) S1 = 0.0D0
        C(I) = C1
        S(I) = S1
        IF (IABS(K-IA).GT.1) GO TO 30
        IF (IABS(K-IA).EQ.1) GO TO 20
        C(I) = C1 - SEPS
        S(I) = S1
        C(I+1) = C1
        S(I+1) = S1
        C(I+2) = C1 + SEPS
        S(I+2) = S1
        I = I + 3
        GO TO 40
   20   CONTINUE
        C(I) = C1 - SEPS
        S(I) = S1
        C(I+1) = C1 + SEPS
        S(I+1) = S1
        I = I + 2
        GO TO 40
   30   CONTINUE
        I = I + 1
   40 CONTINUE
      S(1) = -EPS
      ITL = I - 1
      XNU(1) = 0.0D0
      XNU(2) = 0.3D0
      XNU(3) = 0.7D0
      XNU(4) = 1.0D0
      XNU(5) = 1.3D0
      XNU(6) = 1.7D0
      XNU(7) = FNUL + 1.1D0
      LFLG = 0
      DO 260 KODE=1,2
        DO 250 N=1,4
          DO 240 NU=1,7
            FNU = XNU(NU)
            DO 230 ICASE=1,3
              IRB = MIN0(2,ICASE)
              DO 220 IR=IRB,4
                GO TO (50, 60, 70), ICASE
   50           CONTINUE
                R = (EPS*DBLE(FLOAT(4-IR))+2.0D0*DBLE(FLOAT(IR-1)))/
     *           3.0D0
                GO TO 80
   60           CONTINUE
                R = (2.0D0*DBLE(FLOAT(4-IR))+R2*DBLE(FLOAT(IR-1)))/3.0D0
                GO TO 80
   70           CONTINUE
                IF (R2.EQ.RM) GO TO 230
                R = (R2*DBLE(FLOAT(4-IR))+RM*DBLE(FLOAT(IR-1)))/3.0D0
   80           CONTINUE
                GNU = FNU + DBLE(FLOAT(N-1))
C-----------------------------------------------------------------------
C     10.*AA IS APPROX. LOCAL MAX FOR REAL OR NEAR REAL ARGUMENTS WHEN
C     GNU.LT.R
C-----------------------------------------------------------------------
                AA = 0.07988D0/DSQRT(R)
                DO 210 IT=1,ITL
                  ZR = R*C(IT)
                  ZI = R*S(IT)
                  GNU = FNU + DBLE(FLOAT(N-1))
                  IF (R.LT.GNU) GO TO 140
C-----------------------------------------------------------------------
C     CASES FOR CABS(Z).GE.FNU+N-1
C-----------------------------------------------------------------------
                  CALL ZBESJ(ZR, ZI, FNU, KODE, N, VR, VI, NZ, IERR)
                  IF (NZ.NE.0) GO TO 210
                  CALL ZBESH(ZR, ZI, FNU, KODE, 1, N, WR, WI, NZ1, IERR)
                  CALL ZBESH(ZR, ZI, FNU, KODE, 2, N, YR, YI, NZ2, IERR)
                  IF (KODE.EQ.1) GO TO 160
C-----------------------------------------------------------------------
C     SCALING ADJUSTMENTS IN H FUNCTIONS FOR KODE=2
C-----------------------------------------------------------------------
                  CC = -ZI - DABS(ZI)
                  IF (CC.GT.(-ALIM)) GO TO 90
                  COE1R = 0.0D0
                  COE1I = 0.0D0
                  GO TO 100
   90             CONTINUE
                  CWR = CC
                  CWI = ZR
                  CALL ZEXP(CWR, CWI, COE1R, COE1I)
  100             CONTINUE
                  DD = ZI - DABS(ZI)
                  IF (DD.GT.(-ALIM)) GO TO 110
                  COE2R = 0.0D0
                  COE2I = 0.0D0
                  GO TO 120
  110             CONTINUE
                  CWR = DD
                  CWI = -ZR
                  CALL ZEXP(CWR, CWI, COE2R, COE2I)
  120             CONTINUE
                  DO 130 KK=1,N
                    STR = YR(KK)*COE2R - YI(KK)*COE2I
                    YI(KK) = YR(KK)*COE2I + YI(KK)*COE2R
                    YR(KK) = STR
                    STR = WR(KK)*COE1R - WI(KK)*COE1I
                    WI(KK) = WR(KK)*COE1I + WI(KK)*COE1R
                    WR(KK) = STR
  130             CONTINUE
                  GO TO 160
C-----------------------------------------------------------------------
C     CASES FOR CABS(Z).LT.FNU+N-1
C-----------------------------------------------------------------------
  140             CONTINUE
                  M = N + 16
                  CALL ZBESJ(ZR, ZI, FNU, KODE, M, VR, VI, NZ1, IERR)
                  IF (NZ1.GT.10) GO TO 210
                  CALL ZBESJ(ZR, ZI, FNU, KODE, N, WR, WI, NZ2, IERR)
                  IF (NZ2.NE.0) GO TO 210
                  DO 150 KK=1,N
                    YR(KK) = WR(KK)
                    YI(KK) = WI(KK)
  150             CONTINUE
  160             CONTINUE
                  MFLG = 0
                  DO 190 I=1,N
                    CWR = (WR(I)+YR(I))*HALFR - (WI(I)+YI(I))*HALFI
                    CWI = (WR(I)+YR(I))*HALFI + (WI(I)+YI(I))*HALFR
                    AV = ZABS(VR(I),VI(I))
                    AR = CWR - VR(I)
                    AI = CWI - VI(I)
                    ER = ZABS(AR,AI)
                    IF ((IT.EQ.1) .OR. (IT.EQ.9) .OR. (IT.EQ.17)) GO TO
     *               170
                    ER = ER/AV
                    GO TO 180
  170               CONTINUE
                    IF ((GNU.LT.R) .AND. (AV.LT.AA)) GO TO 180
                    ER = ER/AV
  180               CONTINUE
                    AER(I) = ER
                    IF (ER.GT.ERTOL) MFLG = 1
  190             CONTINUE
                  IF (MFLG.EQ.0) GO TO 210
                  IF (LFLG.EQ.1) GO TO 200
                  WRITE (LUN,99995) ERTOL
99995             FORMAT (/41H CASES WHICH VIOLATE THE RELATIVE ERROR T,
     *             16HEST WITH ERTOL =, D12.4/)
                  WRITE (LUN,99994)
99994             FORMAT (/14H OUTPUT FORMAT/23H KODE,N,IR,IT,NZ1,NZ2,I,
     *             4HCASE)
                  WRITE (LUN,99993)
99993             FORMAT (12H ER(K),K=1,N/26H Z,FNU,Y(KK),W(KK),V(KK), ,
     *             35HKK=INDEX OF FIRST NON-ZERO Y,W PAIR/)
                  LFLG = 1
  200             CONTINUE
                  KK = MAX0(NZ1,NZ2) + 1
                  KK = MIN0(N,KK)
                  IF (R.LT.GNU) KK = N - NZ2
                  WRITE (LUN,99992) KODE, N, IR, IT, NZ1, NZ2, ICASE
99992             FORMAT (8I5)
                  WRITE (LUN,99991) (AER(K),K=1,N)
                  WRITE (LUN,99991) ZR, ZI, FNU, YR(KK), YI(KK),
     *             WR(KK), WI(KK), VR(KK), VI(KK)
99991             FORMAT (9D12.4)
  210           CONTINUE
  220         CONTINUE
  230       CONTINUE
  240     CONTINUE
  250   CONTINUE
  260 CONTINUE
      IF (LFLG.EQ.0) WRITE (LUN,99990)
99990 FORMAT (/16H QUICK CHECKS OK/)
      STOP
      END
