      PROGRAM CQCBY(INPUT,OUTPUT,TAPE7=OUTPUT)
C
C     CQCBY IS A QUICK CHECK ROUTINE FOR THE COMPLEX Y BESSEL FUNCTION
C     GENERATED BY SUBROUTINE CBESY.
C
C     CQCBY GENERATES SEQUENCES OF Y BESSEL FUNCTIONS FROM
C     CBESY AND CHECKS THEM AGAINST THE EVALUATION FROM THE FORMULA
C
C      Y(FNU,Z*ROT) = C(FNU+1)*I(FNU,Z)-(2/PI)*CONJG(C(FNU))*K(FNU,Z)
C           ROT=CEXP(PI*I/2) , C(FNU)=CEXP(PI*FNU*I/2) , I**2=-1
C                        -PI.LT.ARG(Z).LE.PI/2
C
C     IN THE (Z,FNU) SPACE.
C
C     MACHINE CONSTANTS ARE DEFINED IN FUNCTIONS I1MACH, R1MACH, AND
C     D1MACH. THESE MUST BE SELECTED BY THE USER OR SET ACCORDING TO
C     PROLOGUE INSTRUCTIONS.
C
      COMPLEX CI, CIP, COE1, COE2, CSGN, CSPN, CW, CWRK, V, W, Y, Z, ZN
      REAL AA, AER, ALIM, ARG, ATOL, AV, C, CC, C1, DIG, ELIM, EPS, ER,
     * ERTOL, FAC, FFNU, FNU, FNUL, HPI, PI, R, RHPI, RL, RM, R1M5, R2,
     * S, SEPS, S1, T, TOL, TPI, XNU, XX, YY, R1MACH
      INTEGER I, IA, ICASE, IFNU, IL, IR, IRB, IT, ITL, I4, K, KK,
     * KODE, K1, K2, LFLG, LUN, MFLG, N, NU, NZ1, NZ2, IERR, I1MACH
      DIMENSION C(25), S(25), AER(25), XNU(7), Y(20), W(20), V(20),
     * CIP(4), CWRK(20)
      DATA CIP(1),CIP(2),CIP(3),CIP(4)/
     * (1.0E0,0.0E0) , (0.0E0,1.0E0) , (-1.0E0,0.0E0) , (0.0E0,-1.0E0) /
      DATA LUN /7/
C-----------------------------------------------------------------------
C     SET PARAMETERS RELATED TO MACHINE CONSTANTS.
C     TOL IS THE APPROXIMATE UNIT ROUNDOFF LIMITED TO 1.0E-18.
C     ELIM IS THE APPROXIMATE EXPONENTIAL OVER- AND UNDERFLOW LIMIT.
C     EXP(-ELIM).LT.EXP(-ALIM)=EXP(-ELIM)/TOL    AND
C     EXP(ELIM).GT.EXP(ALIM)=EXP(ELIM)*TOL       ARE INTERVALS NEAR
C     UNDERFLOW AND OVERFLOW LIMITS WHERE SCALED ARITHMETIC IS DONE.
C     RL IS THE LOWER BOUNDARY OF THE ASYMPTOTIC EXPANSION FOR LARGE Z.
C     DIG = NUMBER OF BASE 10 DIGITS IN TOL = 10**(-DIG).
C     FNUL IS THE LOWER BOUNDARY OF THE ASYMPTOTIC SERIES FOR LARGE FNU
C-----------------------------------------------------------------------
      TOL = AMAX1(R1MACH(4),1.0E-18)
      K1 = I1MACH(12)
      K2 = I1MACH(13)
      R1M5 = R1MACH(5)
      K = MIN0(IABS(K1),IABS(K2))
      ELIM = 2.303E0*(FLOAT(K)*R1M5-3.0E0)
      K1 = I1MACH(11) - 1
      AA = R1M5*FLOAT(K1)
      DIG = AMIN1(AA,18.0E0)
      AA = AA*2.303E0
      ALIM = ELIM + AMAX1(-AA,-41.45E0)
      FNUL = 10.0E0 + 6.0E0*(DIG-3.0E0)
      RL = 1.2E0*DIG + 3.0E0
      RM = 0.5E0*(ALIM+ELIM)
      RM=AMIN1(RM,650.0E0)
      R2 = AMIN1(RM,FNUL)
C-----------------------------------------------------------------------
      WRITE (LUN,99999)
99999 FORMAT (54H QUICK CHECK ROUTINE FOR THE Y BESSEL FUNCTION FROM CB,
     * 3HESY/)
      WRITE (LUN,99998)
99998 FORMAT (37H PARAMETERS TOL,ELIM,ALIM,RL,FNUL,DIG)
      WRITE (LUN,99997) TOL, ELIM, ALIM, RL, FNUL, DIG
99997 FORMAT (6E12.4/)
      ERTOL = TOL*1.0E+5
      CI = CMPLX(0.0E0,1.0E0)
      FAC = 100.0E0
      ATOL = FAC*TOL
      HPI = 2.0E0*ATAN(1.0E0)
      RHPI = 1.0E0/HPI
      PI = HPI + HPI
      TPI = PI + PI
      I = 1
      IA = 4
      EPS = 0.01E0
      SEPS = EPS
      IL = 13
C-----------------------------------------------------------------------
C     TEST 13 VALUES OF Z IN -PI/2.LT.ARG(Z).LE.PI
C-----------------------------------------------------------------------
      WRITE (LUN,99996)
99996 FORMAT (/28H CHECKS IN THE (Z,FNU) SPACE/)
      DO 40 K=1,IL
        IF (K.NE.7) GO TO 10
        IA = 10
        SEPS = -SEPS
   10   CONTINUE
        IF (IABS(K-IA).EQ.2) GO TO 40
        T = -PI + TPI*FLOAT(K-1)/FLOAT(IL-1)
        C1 = COS(T)
        S1 = SIN(T)
        IF (ABS(C1).LT.ATOL) C1 = 0.0E0
        IF (ABS(S1).LT.ATOL) S1 = 0.0E0
        C(I) = C1
        S(I) = S1
        IF (IABS(K-IA).GT.1) GO TO 30
        IF (IABS(K-IA).EQ.1) GO TO 20
        C(I) = C1 - SEPS
        S(I) = S1
        C(I+1) = C1
        S(I+1) = S1
        C(I+2) = C1 + SEPS
        S(I+2) = S1
        I = I + 3
        GO TO 40
   20   CONTINUE
        C(I) = C1 - SEPS
        S(I) = S1
        C(I+1) = C1 + SEPS
        S(I+1) = S1
        I = I + 2
        GO TO 40
   30   CONTINUE
        I = I + 1
   40 CONTINUE
      S(1) = -EPS
      ITL = I - 1
      XNU(1) = 0.0E0
      XNU(2) = 0.3E0
      XNU(3) = 0.7E0
      XNU(4) = 1.0E0
      XNU(5) = 1.3E0
      XNU(6) = 1.7E0
      XNU(7) = FNUL + 1.1E0
      LFLG = 0
      DO 190 KODE=1,2
        DO 180 N=1,4
          DO 170 NU=1,7
            FNU = XNU(NU)
            IFNU = INT(FNU)
            FFNU = FNU - FLOAT(IFNU)
            ARG = HPI*FFNU
            CSGN = CMPLX(COS(ARG),SIN(ARG))
            I4 = MOD(IFNU,4) + 1
            CSGN = CSGN*CIP(I4)
            CSPN = CONJG(CSGN)*CMPLX(RHPI,0.0E0)
            CSGN = CSGN*CI
            DO 160 ICASE=1,3
              IRB = MIN0(2,ICASE)
              DO 150 IR=IRB,4
                GO TO (50, 60, 70), ICASE
   50           CONTINUE
                R = (EPS*FLOAT(4-IR)+2.0E0*FLOAT(IR-1))/3.0E0
                GO TO 80
   60           CONTINUE
                R = (2.0E0*FLOAT(4-IR)+R2*FLOAT(IR-1))/3.0E0
                GO TO 80
   70           CONTINUE
                IF (R2.EQ.RM) GO TO 160
                R = (R2*FLOAT(4-IR)+RM*FLOAT(IR-1))/3.0E0
   80           CONTINUE
                DO 140 IT=1,13
                  Z = CMPLX(R*C(IT),R*S(IT))
                  CALL CBESI(Z, FNU, KODE, N, W, NZ2, IERR)
                  IF (NZ2.NE.0) GO TO 140
                  CALL CBESK(Z, FNU, KODE, N, Y, NZ1, IERR)
                  IF (NZ1.NE.0) GO TO 140
                  ZN = Z*CI
                  CALL CBESY(ZN, FNU, KODE, N, V, NZ, CWRK, IERR)
                  IF (NZ.NE.0) GO TO 140
                  COE1 = CSGN
                  COE2 = CSPN
                  IF (KODE.EQ.1) GO TO 100
C-----------------------------------------------------------------------
C     SCALING ADJUSTMENTS IN I AND K FUNCTIONS FOR KODE=2
C-----------------------------------------------------------------------
                  XX = REAL(Z)
                  YY = AIMAG(Z)
                  CC = -XX - ABS(XX)
                  IF (CC.GT.(-ALIM)) GO TO 90
                  COE2 = CMPLX(0.0E0,0.0E0)
                  GO TO 140
   90             CONTINUE
                  ZN = CMPLX(CC,-YY)
                  COE2 = COE2*CEXP(ZN)
  100             CONTINUE
                  DO 110 KK=1,N
                    Y(KK) = Y(KK)*COE2
                    W(KK) = W(KK)*COE1
                    COE1 = COE1*CI
                    COE2 = -COE2*CI
  110             CONTINUE
                  MFLG = 0
                  DO 120 I=1,N
                    CW = W(I) - Y(I)
                    AV = CABS(V(I))
                    ER = CABS(CW-V(I))/AV
                    AER(I) = ER
                    IF (ER.GT.ERTOL) MFLG = 1
  120             CONTINUE
                  IF (MFLG.EQ.0) GO TO 140
                  IF (LFLG.EQ.1) GO TO 130
                  WRITE (LUN,99995) ERTOL
99995             FORMAT (/41H CASES WHICH VIOLATE THE RELATIVE ERROR T,
     *             19HEST WITH ERTOL   = , E12.4/)
                  WRITE (LUN,99994)
99994             FORMAT (/14H OUTPUT FORMAT/23H KODE,N,IR,IT,NZ1,NZ2,I,
     *             4HCASE)
                  WRITE (LUN,99993)
99993             FORMAT (12H ER(K),K=1,N/26H Z,FNU,Y(KK),W(KK),V(KK), ,
     *             35HKK=INDEX OF FIRST NON-ZERO Y,W PAIR/)
                  LFLG = 1
  130             CONTINUE
                  KK = MAX0(NZ1,NZ2) + 1
                  KK = MIN0(N,KK)
                  WRITE (LUN,99992) KODE, N, IR, IT, NZ1, NZ2, ICASE
99992             FORMAT (8I5)
                  WRITE (LUN,99991) (AER(K),K=1,N)
                  WRITE (LUN,99991) Z, FNU, Y(KK), W(KK), V(KK)
99991             FORMAT (9E12.4)
  140           CONTINUE
  150         CONTINUE
  160       CONTINUE
  170     CONTINUE
  180   CONTINUE
  190 CONTINUE
      IF (LFLG.EQ.0) WRITE (LUN,99990)
99990 FORMAT (/16H QUICK CHECKS OK/)
      STOP
      END
