      PROGRAM CQCBK(INPUT,OUTPUT,TAPE7=OUTPUT)
C
C     CQCBK IS A QUICK CHECK ROUTINE FOR THE COMPLEX K BESSEL FUNCTION
C     GENERATED BY SUBROUTINE CBESK.
C
C     CQCBK GENERATES SEQUENCES OF I AND K BESSEL FUNCTIONS FROM
C     CBESI AND CBESK AND CHECKS THEM AGAINST THE WRONSKIAN EVALUATION
C     IN THE (Z,FNU) SPACE.
C
C     MACHINE CONSTANTS ARE DEFINED IN FUNCTIONS I1MACH, R1MACH, AND
C     D1MACH. THESE MUST BE SELECTED BY THE USER OR SET ACCORDING TO
C     PROLOGUE INSTRUCTIONS.
C
      COMPLEX CONE, CSGN, CV, CW, CY, W, Y, Z, ZN
      REAL AA, AER, ALIM, ARG, ATOL, AXX, C, C1, DIG, ELIM, EPS, ER,
     * ERTOL, FAC, FFNU, FNU, FNUL, HPI, PI, R, RL, RM, R1M5, R2, S,
     * SEPS, S1, T, TOL, TPI, XNU, XX, R1MACH
      INTEGER I, IA, ICASE, IFNU, IL, IR, IRB, IT, ITL, K, KK, KODE,
     * K1, K2, LFLG, LUN, MFLG, N, NU, NZ1, NZ2, N1, IERR, I1MACH
      DIMENSION C(25), S(25), AER(25), XNU(7), Y(20), W(20)
      DATA LUN /7/
C-----------------------------------------------------------------------
C     SET PARAMETERS RELATED TO MACHINE CONSTANTS.
C     TOL IS THE APPROXIMATE UNIT ROUNDOFF LIMITED TO 1.0E-18.
C     ELIM IS THE APPROXIMATE EXPONENTIAL OVER- AND UNDERFLOW LIMIT.
C     EXP(-ELIM).LT.EXP(-ALIM)=EXP(-ELIM)/TOL    AND
C     EXP(ELIM).GT.EXP(ALIM)=EXP(ELIM)*TOL       ARE INTERVALS NEAR
C     UNDERFLOW AND OVERFLOW LIMITS WHERE SCALED ARITHMETIC IS DONE.
C     RL IS THE LOWER BOUNDARY OF THE ASYMPTOTIC EXPANSION FOR LARGE Z.
C     DIG = NUMBER OF BASE 10 DIGITS IN TOL = 10**(-DIG).
C     FNUL IS THE LOWER BOUNDARY OF THE ASYMPTOTIC SERIES FOR LARGE FNU
C-----------------------------------------------------------------------
      TOL = AMAX1(R1MACH(4),1.0E-18)
      K1 = I1MACH(12)
      K2 = I1MACH(13)
      R1M5 = R1MACH(5)
      K = MIN0(IABS(K1),IABS(K2))
      ELIM = 2.303E0*(FLOAT(K)*R1M5-3.0E0)
      K1 = I1MACH(11) - 1
      AA = R1M5*FLOAT(K1)
      DIG = AMIN1(AA,18.0E0)
      AA = AA*2.303E0
      ALIM = ELIM + AMAX1(-AA,-41.45E0)
      FNUL = 10.0E0 + 6.0E0*(DIG-3.0E0)
      RL = 1.2E0*DIG + 3.0E0
      RM = 0.5E0*(ALIM+ELIM)
      RM=AMIN1(RM,650.0E0)
      R2 = AMIN1(RM,FNUL)
C-----------------------------------------------------------------------
      WRITE (LUN,99999)
99999 FORMAT (54H QUICK CHECK ROUTINE FOR THE K BESSEL FUNCTION FROM CB,
     * 3HESK/)
      WRITE (LUN,99998)
99998 FORMAT (37H PARAMETERS TOL,ELIM,ALIM,RL,FNUL,DIG)
      WRITE (LUN,99997) TOL, ELIM, ALIM, RL, FNUL, DIG
99997 FORMAT (6E12.4/)
      ERTOL = TOL*1.0E+5
      CONE = CMPLX(1.0E0,0.0E0)
      FAC = 100.0E0
      ATOL = FAC*TOL
      HPI = 2.0E0*ATAN(1.0E0)
      PI = HPI + HPI
      TPI = PI + PI
      I = 1
      IA = 4
      EPS = 0.01E0
      SEPS = EPS
      IL = 13
C-----------------------------------------------------------------------
C     TEST 17 VALUES OF Z IN -PI.LT.ARG(Z).LE.PI NEAR FORMULA BOUNDARIES
C-----------------------------------------------------------------------
      WRITE (LUN,99996)
99996 FORMAT (/28H CHECKS IN THE (Z,FNU) SPACE/)
      DO 40 K=1,IL
        IF (K.NE.7) GO TO 10
        IA = 10
        SEPS = -SEPS
   10   CONTINUE
        IF (IABS(K-IA).EQ.2) GO TO 40
        T = -PI + TPI*FLOAT(K-1)/FLOAT(IL-1)
        C1 = COS(T)
        S1 = SIN(T)
        IF (ABS(C1).LT.ATOL) C1 = 0.0E0
        IF (ABS(S1).LT.ATOL) S1 = 0.0E0
        C(I) = C1
        S(I) = S1
        IF (IABS(K-IA).GT.1) GO TO 30
        IF (IABS(K-IA).EQ.1) GO TO 20
        C(I) = C1 - SEPS
        S(I) = S1
        C(I+1) = C1
        S(I+1) = S1
        C(I+2) = C1 + SEPS
        S(I+2) = S1
        I = I + 3
        GO TO 40
   20   CONTINUE
        C(I) = C1 - SEPS
        S(I) = S1
        C(I+1) = C1 + SEPS
        S(I+1) = S1
        I = I + 2
        GO TO 40
   30   CONTINUE
        I = I + 1
   40 CONTINUE
      S(1) = -EPS
      ITL = I - 1
      XNU(1) = 0.0E0
      XNU(2) = 0.3E0
      XNU(3) = 0.7E0
      XNU(4) = 1.0E0
      XNU(5) = 1.3E0
      XNU(6) = 1.7E0
      XNU(7) = FNUL + 1.1E0
      LFLG = 0
      DO 200 KODE=1,2
        DO 190 N=1,4
          N1 = N + 1
          DO 180 NU=1,7
            FNU = XNU(NU)
            IFNU = INT(FNU)
            FFNU = FNU - FLOAT(IFNU)
            ARG = PI*FFNU
            CSGN = CMPLX(COS(ARG),SIN(ARG))
            IF (MOD(IFNU,2).EQ.1) CSGN = -CSGN
            DO 170 ICASE=1,3
              IRB = MIN0(2,ICASE)
              DO 160 IR=IRB,4
                GO TO (50, 60, 70), ICASE
   50           CONTINUE
                R = (EPS*FLOAT(4-IR)+2.0E0*FLOAT(IR-1))/3.0E0
                GO TO 80
   60           CONTINUE
                R = (2.0E0*FLOAT(4-IR)+R2*FLOAT(IR-1))/3.0E0
                GO TO 80
   70           CONTINUE
                IF (R2.EQ.RM) GO TO 170
                R = (R2*FLOAT(4-IR)+RM*FLOAT(IR-1))/3.0E0
   80           CONTINUE
                DO 150 IT=1,ITL
                  Z = CMPLX(R*C(IT),R*S(IT))
                  CALL CBESI(Z, FNU, KODE, N1, W, NZ2, IERR)
                  IF (NZ2.NE.0) GO TO 150
                  CALL CBESK(Z, FNU, KODE, N1, Y, NZ1, IERR)
                  IF (ICASE.EQ.1) GO TO 100
                  IF (IABS(IT-9).LE.4) GO TO 100
C-----------------------------------------------------------------------
C     IN THE LEFT HALF PLANE, THE ANALYTIC CONTINUATION FORMULA FOR K
C     INTRODUCES AN I FUNCTION. THE DOMINANT TERMS IN THE WRONSKIAN
C     I(FNU,Z)*I(FNU+1,Z) CANCEL OUT GIVING LOSSES OF SIGNIFICANCE.
C     THIS CANCELATION CAN BE DONE ANALYTICALLY TO GIVE A WRONSKIAN
C     IN TERMS OF I IN THE LEFT HALF PLANE AND K IN THE RIGHT HALF
C     PLANE.
C-----------------------------------------------------------------------
                  ZN = -Z
                  CALL CBESK(ZN, FNU, KODE, N1, Y, NZ1, IERR)
                  ZN = CSGN
                  IF (IT.GT.9) ZN = CONJG(ZN)
                  DO 90 KK=1,N1
                    Y(KK) = Y(KK)*ZN
                    ZN = -ZN
   90             CONTINUE
  100             CONTINUE
C-----------------------------------------------------------------------
C     ADJUSTMENTS TO WRONSKIAN DUE TO SCALING OF I AND K FUNCTIONS
C     ON KODE=2
C-----------------------------------------------------------------------
                  CV = CONE/Z
                  IF (KODE.EQ.1) GO TO 120
                  XX = REAL(Z)
                  AXX = ABS(XX)
                  ZN = CMPLX(-AXX,0.0E0)
                  CV = ZN + Z
                  IF (ICASE.EQ.1) GO TO 110
                  IF (IABS(IT-9).LE.4) GO TO 110
                  CV = ZN - Z
  110             CONTINUE
                  CV = CEXP(CV)/Z
  120             CONTINUE
                  MFLG = 0
                  DO 130 I=1,N
                    CW = W(I)*Y(I+1)
                    CY = W(I+1)*Y(I)
                    CY = CY + CW - CV
                    ER = CABS(CY)/CABS(CV)
                    AER(I) = ER
                    IF (ER.GT.ERTOL) MFLG = 1
  130             CONTINUE
                  IF (MFLG.EQ.0) GO TO 150
                  IF (LFLG.EQ.1) GO TO 140
                  WRITE (LUN,99995) ERTOL
99995             FORMAT (/41H CASES WHICH VIOLATE THE RELATIVE ERROR T,
     *             16HEST WITH ERTOL =, E12.4/)
                  WRITE (LUN,99994)
99994             FORMAT (/14H PUTPUT FORMAT/23H KODE,N,IR,IT,NZ1,NZ2,I,
     *             4HCASE)
                  WRITE (LUN,99993)
99993             FORMAT (12H ER(K),K=1,N/26H Z,FNU,Y(KK),W(KK), KK=IND,
     *             25HEX OF FIRST NON-ZERO PAIR/)
                  LFLG = 1
  140             CONTINUE
                  KK = MAX0(NZ1,NZ2) + 1
                  KK = MIN0(N,KK)
                  WRITE (LUN,99992) KODE, N, IR, IT, NZ1, NZ2, ICASE
99992             FORMAT (8I5)
                  WRITE (LUN,99991) (AER(K),K=1,N)
                  WRITE (LUN,99991) Z, FNU, Y(KK), W(KK)
99991             FORMAT (7E12.4)
  150           CONTINUE
  160         CONTINUE
  170       CONTINUE
  180     CONTINUE
  190   CONTINUE
  200 CONTINUE
      IF (LFLG.EQ.0) WRITE (LUN,99990)
99990 FORMAT (/16H QUICK CHECKS OK/)
      STOP
      END
