      PROGRAM CQCAI(INPUT,OUTPUT,TAPE7=OUTPUT)
C
C     CQCAI IS A QUICK CHECK ROUTINE FOR THE COMPLEX AIRY FUNCTIONS
C     GENERATED BY SUBROUTINES CAIRY AND CBIRY.
C
C     CQCAI GENERATES AIRY FUNCTIONS AND THEIR DERIVATIVES FROM CAIRY
C     AND CBIRY AND CHECKS THEM AGAINST THE WRONSKIAN EVALUATION IN THE
C     Z PLANE.
C
C     MACHINE CONSTANTS ARE DEFINED IN FUNCTIONS I1MACH, R1MACH, AND
C     D1MACH. THESE MUST BE SELECTED BY THE USER OR SET ACCORDING TO
C     PROLOGUE INSTRUCTIONS.
C
      COMPLEX CON1, CON2, CON3, CV, CW, CY, W, Y, Z, ZR
      REAL AA, ACW, ACY, ALIM, ARG, ARZR, ATOL, AV, A1, A2, C, C1, C23,
     * DIG, ELIM, EPS, ER, ERTOL, FAC, FNUL, FPI, HPI, PI, R, RL, RPI,
     * RTPI, RZR, R1M5, S, SEPS, SPI, S1, T, TOL, TPI, TPI3, RM, R1MACH
      INTEGER I, IA, ICASE, IL, IR, IRSET, IT, ITL, K, KODE, K1,
     * K2, LFLG, LUN, NZ1, NZ2, NZ3, NZ4, IERR, I1MACH
      DIMENSION C(20), S(20), Y(20), W(20)
      DATA LUN /7/
C-----------------------------------------------------------------------
C     SET PARAMETERS RELATED TO MACHINE CONSTANTS.
C     TOL IS THE APPROXIMATE UNIT ROUNDOFF LIMITED TO 1.0E-18.
C     ELIM IS THE APPROXIMATE EXPONENTIAL OVER- AND UNDERFLOW LIMIT.
C     EXP(-ELIM).LT.EXP(-ALIM)=EXP(-ELIM)/TOL    AND
C     EXP(ELIM).GT.EXP(ALIM)=EXP(ELIM)*TOL       ARE INTERVALS NEAR
C     UNDERFLOW AND OVERFLOW LIMITS WHERE SCALED ARITHMETIC IS DONE.
C     RL IS THE LOWER BOUNDARY OF THE ASYMPTOTIC EXPANSION FOR LARGE Z.
C     DIG = NUMBER OF BASE 10 DIGITS IN TOL = 10**(-DIG).
C     FNUL IS THE LOWER BOUNDARY OF THE ASYMPTOTIC SERIES FOR LARGE FNU
C-----------------------------------------------------------------------
      TOL = AMAX1(R1MACH(4),1.0E-18)
      K1 = I1MACH(12)
      K2 = I1MACH(13)
      R1M5 = R1MACH(5)
      K = MIN0(IABS(K1),IABS(K2))
      ELIM = 2.303E0*(FLOAT(K)*R1M5-3.0E0)
      K1 = I1MACH(11) - 1
      AA = R1M5*FLOAT(K1)
      DIG = AMIN1(AA,18.0E0)
      AA = AA*2.303E0
      ALIM = ELIM + AMAX1(-AA,-41.45E0)
      FNUL = 10.0E0 + 6.0E0*(DIG-3.0E0)
      RL = 1.2E0*DIG + 3.0E0
C-----------------------------------------------------------------------
      WRITE (LUN,99999)
99999 FORMAT (54H QUICK CHECK ROUTINE FOR THE AIRY FUNCTIONS FROM CAIRY,
     * 10H AND CBIRY/)
      WRITE (LUN,99998)
99998 FORMAT (37H PARAMETERS TOL,ELIM,ALIM,RL,FNUL,DIG)
      WRITE (LUN,99997) TOL, ELIM, ALIM, RL, FNUL, DIG
99997 FORMAT (6E12.4/)
      ERTOL = TOL*1.0E+5
      FAC = 100.0E0
      RM = 0.5E0*(ALIM+ELIM)
      RM=AMIN1(RM,650.0E0)
      ATOL = FAC*TOL
      FPI = ATAN(1.0E0)
      HPI = FPI + FPI
      PI = HPI + HPI
      TPI = PI + PI
      RPI = 1.0E0/PI
      TPI3 = TPI/3.0E0
      CON1 = CMPLX(COS(TPI3),SIN(TPI3))
      SPI = PI/6.0E0
      RTPI = 1.0E0/TPI
      A1 = RTPI*COS(SPI)
      A2 = RTPI*SIN(SPI)
      CON2 = CMPLX(A1,-A2)
      CON3 = CMPLX(RPI,0.0E0)
      C23 = 2.0E0/3.0E0
      I = 1
      IA = 3
      EPS = 0.01E0
      SEPS = EPS
      IL = 7
C-----------------------------------------------------------------------
C     TEST 9 VALUES OF Z IN -PI.LT.ARG(Z).LE.PI NEAR FORMULA BOUNDARIES
C-----------------------------------------------------------------------
      WRITE (LUN,99996)
99996 FORMAT (/22H CHECKS IN THE Z PLANE/)
      DO 30 K=1,IL
        IF (K.NE.4) GO TO 10
        IA = 5
        SEPS = -SEPS
   10   CONTINUE
        T = -PI + TPI*FLOAT(K-1)/FLOAT(IL-1)
        C1 = COS(T)
        S1 = SIN(T)
        IF (ABS(C1).LT.ATOL) C1 = 0.0E0
        IF (ABS(S1).LT.ATOL) S1 = 0.0E0
        C(I) = C1
        S(I) = S1
        IF (IABS(K-IA).GT.0) GO TO 20
        C(I) = C1 - SEPS
        S(I) = S1
        C(I+1) = C1 + SEPS
        S(I+1) = S1
        I = I + 2
        GO TO 30
   20   CONTINUE
        I = I + 1
   30 CONTINUE
      S(1) = -EPS
      ITL = I - 1
      LFLG = 0
      DO 180 ICASE=1,2
C-----------------------------------------------------------------------
C     ICASE=1 COMPUTES WRON(AI(Z),BI(Z))     =CON3
C     ICASE=2 COMPUTES WRON(AI(Z),AI(Z*CON1))=CON2
C-----------------------------------------------------------------------
        DO 170 KODE=1,2
          DO 160 IRSET=1,3
            IRB = MIN0(IRSET,2)
            DO 150 IR=IRB,4
              GO TO (40, 50, 60), IRSET
   40         CONTINUE
              R = 2.0E0*FLOAT(IR-1)/3.0E0
              GO TO 70
   50         CONTINUE
              R = (2.0E0*FLOAT(4-IR)+RL*FLOAT(IR-1))/3.0E0
              GO TO 70
   60         CONTINUE
              R = (RL*FLOAT(4-IR)+RM*FLOAT(IR-1))/3.0E0
   70         CONTINUE
              DO 140 IT=1,ITL
                Z = CMPLX(R*C(IT),R*S(IT))
                ZR = CMPLX(C23,0.0E0)*Z*CSQRT(Z)
                RZR = REAL(ZR)
                ARZR = ABS(RZR)
                IF (ARZR.EQ.0.0E0) GO TO 80
                ARG = -ARZR - 0.5E0*ALOG(ARZR) + 0.226E0
                ARG = ARG + ARG
                IF (ARG.LT.(-ELIM)) GO TO 140
   80           CONTINUE
                CALL CAIRY(Z, 0, KODE, Y(1), NZ1, IERR)
                CALL CAIRY(Z, 1, KODE, Y(2), NZ2, IERR)
                IF (ICASE.EQ.2) GO TO 100
                CALL CBIRY(Z, 0, KODE, W(1), IERR)
                CALL CBIRY(Z, 1, KODE, W(2), IERR)
                IF (KODE.EQ.1) GO TO 90
                CV = CMPLX(ARZR,0.0E0) - ZR
                CV = CEXP(CV)
                W(1) = W(1)*CV
                W(2) = W(2)*CV
   90           CONTINUE
                CV = CON3
                NZ3 = 0
                NZ4 = 0
                GO TO 120
  100           CONTINUE
                CV = Z*CON1
                CALL CAIRY(CV, 0, KODE, W(1), NZ3, IERR)
                CALL CAIRY(CV, 1, KODE, W(2), NZ4, IERR)
                IF (KODE.EQ.1) GO TO 110
C----------------------------------------------------------------------
C     WHEN KODE=2,THE SCALING FACTOR EXP(-ZETA1-ZETA2) IS 1.0 FOR
C     -PI.LT.ARG(Z).LE.PI/3 AND EXP(-2.0*ZETA1) FOR -PI/3.LT.ARG(Z)
C     .LE.PI WHERE ZETA1=ZETA2 IN THIS RANGE. THIS IS DUE TO THE FACT
C     THAT ARG(Z*CON1) IS TAKEN TO BE IN (-PI,PI) BY THE PRINCIPAL
C     SQUARE ROOT.
C----------------------------------------------------------------------
                IF (IT.LT.7) GO TO 110
                CV = ZR + ZR
                CV = CEXP(-CV)
                W(1) = W(1)*CV
                W(2) = W(2)*CV
  110           CONTINUE
                W(2) = W(2)*CON1
                CV = CON2
  120           CONTINUE
                AV = CABS(CV)
C-----------------------------------------------------------------------
C     ERROR RELATIVE TO MAXIMUM TERM
C-----------------------------------------------------------------------
                CW = Y(1)*W(2)
                CY = Y(2)*W(1)
                CY = CW - CY - CV
                ACY = CABS(Y(1))*CABS(W(2))
                ACW = CABS(W(1))*CABS(Y(2))
                AV = AMAX1(ACW,ACY,AV)
                ER = CABS(CY)/AV
                IF (ER.LT.ERTOL) GO TO 140
                IF (LFLG.EQ.1) GO TO 130
                WRITE (LUN,99995) ERTOL
99995           FORMAT (/43H CASES WHICH VIOLATE THE RELATIVE ERROR TES,
     *           14HT WITH ERTOL =, E12.4/)
                WRITE (LUN,99994)
99994           FORMAT (/14H OUTPUT FORMAT/25H KODE,IR,IT,NZ1,NZ2,NZ3,N,
     *           14HZ4,IRSET,ICASE)
                WRITE (LUN,99993)
99993           FORMAT (3H ER/22H Z,Y(1),Y(2),W(1),W(2)/)
                LFLG = 1
  130           CONTINUE
                WRITE (LUN,99992) KODE, IR, IT, NZ1, NZ2, NZ3, NZ4,
     *           IRSET, ICASE
99992           FORMAT (9I5)
                WRITE (LUN,99991) ER
                WRITE (LUN,99991) Z, Y(1), Y(2), W(1), W(2)
99991           FORMAT (10E12.4)
  140         CONTINUE
  150       CONTINUE
  160     CONTINUE
  170   CONTINUE
  180 CONTINUE
      IF (LFLG.EQ.0) WRITE (LUN,99990)
99990 FORMAT (/16H QUICK CHECKS OK/)
      STOP
      END
