/* Define MIN and MAX */
 
#ifndef B_MIN
#define B_MIN(a, b)\
((a) < (b) ? (a) : (b))
#endif
 
#ifndef B_MAX
#define B_MAX(a, b)\
((a) > (b) ? (a) : (b))
#endif

/* Memory allocation macros */
 
#define B_ALLOC(ptr, type, count, bytes, ier, label)\
{\
  bytes = sizeof (type) * (count);\
  if (bytes == 0) {\
    ptr = NULL;\
  } else {\
    ptr = (type *) malloc ((unsigned) bytes);\
    if (ptr == NULL) {\
      ier = -8001;\
      goto label;\
    }\
  }\
}
 
#define B_FREE(ptr)\
{\
  free (ptr);\
  ptr = NULL;\
}
 
#define B_REALLOC(ptr, type, count, bytes, ier, label)\
{\
  bytes = sizeof (type) * (count);\
  if (bytes == 0) {\
    B_FREE (ptr);\
  } else {\
    if (ptr == NULL) {\
      ptr = (type *) malloc ((unsigned) bytes);\
    } else {\
      ptr = (type *) realloc (ptr, (unsigned) bytes);\
    }\
    if (ptr == NULL) {\
      ier = -8001;\
      goto label;\
    }\
  }\
}

/* The data structure for an arbitrary multivariate polynomial */

struct MVPOLY {
  long int nind;
  long int ndep;
  long int nterm;
  long int *expon;
  double *bounds;
  double *coefs;
};

typedef struct MVPOLY MVPOLY;

/* These are the prototypes for the routines in MVP */

long int mvaxpy (double a,
                 MVPOLY *x,
                 MVPOLY *y);
long int mvcopy (MVPOLY *x,
                 MVPOLY **y);
long int mvfree (MVPOLY **poly);
long int mvintp (long int ivar,
                 MVPOLY *poly,
                 MVPOLY **ans);
long int mvnorm (MVPOLY *poly,
                 double *norm);
long int mvpder (double *x,
                 long int incx,
                 long int *ider,
                 MVPOLY *poly,
                 double *fval);
long int mvpifn (long int nind,
                 long int ndep,
                 long int nfns,
                 double (*linfun) (MVPOLY *monomial,
                                   long int ixfun,
                                   void *aux),
                 void *aux,
                 double *frhs,
                 long int incp,
                 long int incd,
                 double *bounds,
                 MVPOLY **poly);
long int mvpint (long int nind,
                 long int ndep,
                 long int npts,
                 double *xyz,
                 long int incp,
                 long int incd,
                 double *bounds,
                 MVPOLY **poly);
long int mvprdp (FILE *file,
                 MVPOLY **poly);
long int mvpval (double *x,
                 long int incx,
                 MVPOLY *poly,
                 double *fval);
long int mvpwrt (FILE *file,
                 MVPOLY *poly);

/*-------------------------------------------------*/
/* prototypes for linear algebra utility functions */
/* from lapack                                     */ 
/*-------------------------------------------------*/

int      dcopy_(long int    *n, double     *dx, long int   *incx,
                double     *dy, long int *incy );
 
double    ddot_(long int    *n, double     *dx, long int   *incx,
                double     *dy, long int *incy );
 
int      daxpy_(long int    *n, double     *da, double       *dx,
                long int *incx, double     *dy, long int   *incy) ;
 
int      drscl_(long int    *n, double     *sa, double       *sx,
                long int *incx);

int dgesv_ (long int *n,
            long int *nrhs,
            double *a,
            long int *lda,
            long int *ipiv,
            double *b,
            long int *ldb,
            long int *info);

int dgesvd_(char       *jobu,       char      *jobvh,
            long int      *m,       long int      *n,
            double        *a,       long int    *tda,
            double        *s,       double        *u,
            long int    *tdu,       double       *vh,
            long int   *tdvh,       double     *work,
            long int  *lwork,       long int   *info);
