#include <float.h>
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include "spline.h"

/***********************************************************************
**
**     This procedure outputs a multivariate polynomial data element.
**
**     Thomas Grandine
**     June, 1996
**
***********************************************************************/

long int mvpwrt (FILE *file,
                 MVPOLY *poly)
{
  long int ix;
  long int iy;
  long int ier = 0;

/* Dump out the elements */

  fprintf (file, "%ld %ld %ld\n", poly->nind, poly->ndep, poly->nterm);
  for (ix = 0; ix < poly->nind; ix++) {
    fprintf (file, "%24.16e %24.16e\n", poly->bounds[2 * ix],
             poly->bounds[2 * ix + 1]);
  }
  for (ix = 0; ix < poly->nterm; ix++) {
    for (iy = 0; iy < poly->nind; iy++) {
      fprintf (file, "%ld ", poly->expon[ix * poly->nind + iy]);
    }
    fprintf (file, "\n");
  }
  for (ix = 0; ix < poly->ndep * poly->nterm; ix++) {
    fprintf (file, "%24.16e\n", poly->coefs[ix]);
  }

/* Return the function values */

  return ier;
}
