#include <float.h>
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include "spline.h"

/***********************************************************************
**
**     This procedure reads a multivariate polynomial data element.
**
**     Thomas Grandine
**     June, 1996
**
***********************************************************************/

long int mvprdp (FILE *file,
                 MVPOLY **poly)
{
  long int ix;
  long int iy;
  long int bytes;
  long int ier = 0;
  MVPOLY *mvp = NULL;

/* Allocate a new multivariate polynomial */

  B_ALLOC (mvp, MVPOLY, 1, bytes, ier, END);
  *poly = mvp;

/* Read in the elements */

  fscanf (file, "%ld %ld %ld", &mvp->nind, &mvp->ndep, &mvp->nterm);
  B_ALLOC (mvp->bounds, double, 2 * mvp->nind, bytes, ier, END);
  for (ix = 0; ix < 2 * mvp->nind; ix++) {
    fscanf (file, "%lf", &mvp->bounds[ix]);
  }
  B_ALLOC (mvp->expon, long int, mvp->nind * mvp->nterm,
           bytes, ier, END);
  for (ix = 0; ix < mvp->nterm * mvp->nind; ix++) {
    fscanf (file, "%ld", &mvp->expon[ix]);
  }
  B_ALLOC (mvp->coefs, double, mvp->ndep * mvp->nterm, bytes, ier, END);
  for (ix = 0; ix < mvp->ndep * mvp->nterm; ix++) {
    fscanf (file, "%lf", &mvp->coefs[ix]);
  }

/* Return the function values */

END:
  return ier;
}
