#include <float.h>
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include "spline.h"

/***********************************************************************
**
**     This procedure computes the norm of a multivariate polynomial
**     function.
**
**     Thomas Grandine
**     July, 1996
**
***********************************************************************/

long int mvnorm (MVPOLY *poly,
                 double *norm)
{
  long int ix;
  long int iy;
  long int iz;
  long int ier;
  long int none = 0;
  long int one = 1;
  double zero = 0.0;
  double value;

/* Initialize the answer */

  dcopy_ (&poly->ndep, &zero, &none, norm, &one);

/* Loop through and integrate each of the terms */

  for (ix = 0; ix < poly->nterm; ix++) {
    value = 1.0;
    for (iy = ix; iy < poly->nterm; iy++) {
      for (iz = 0; iz < poly->nind; iz++) {
        value /= poly->expon[ix * poly->nind + iz] +
                 poly->expon[iy * poly->nind + iz] + 1.0;
      }
      for (iz = 0; iz < poly->ndep; iz++) {
        norm[iz] += value * poly->coefs[iz * poly->nterm + ix] *
                            poly->coefs[iz * poly->nterm + iy];
      }
      value = 2.0;
    }
  }

/* Compute the square roots */

  for (ix = 0; ix < poly->ndep; ix++) {
    norm[ix] = sqrt (norm[ix]);
  }

/* Return */

END:
  return ier;
}
