#include <float.h>
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include "spline.h"

/***********************************************************************
**
**     This procedure integrates a multivariate polynomial interpolant
**     with respect to a variable.
**
**     Thomas Grandine
**     June, 1996
**
***********************************************************************/

long int mvintp (long int ivar,
                 MVPOLY *poly,
                 MVPOLY **ans)
{
  long int nt;
  long int ix;
  long int iy;
  long int iz;
  long int bytes;
  long int ier;
  long int ncopy;
  long int none = 0;
  long int one = 1;
  double value;
  double zero = 0.0;
  MVPOLY *npoly = NULL;

/* Allocate the answer */

  B_ALLOC (npoly, MVPOLY, 1, bytes, ier, END);
  *ans = npoly;
  npoly->nind = poly->nind;
  npoly->ndep = poly->ndep;

/* Set up the bounds */

  ncopy = 2 * npoly->nind;
  B_ALLOC (npoly->bounds, double, ncopy, bytes, ier, END);
  dcopy_ (&ncopy, poly->bounds, &one, npoly->bounds, &one);

/* Allocate space for exponents and coefficients */

  B_ALLOC (npoly->expon, long int, npoly->nind * poly->nterm,
           bytes, ier, END);
  B_ALLOC (npoly->coefs, double, npoly->ndep * poly->nterm,
           bytes, ier, END);
  ncopy = npoly->ndep * poly->nterm;
  dcopy_ (&ncopy, &zero, &none, npoly->coefs, &one);
  npoly->nterm = 0;

/* Integrate term by term */

  for (ix = 0; ix < poly->nterm; ix++) {
    nt = npoly->nterm;
    for (iy = 0; iy < poly->nind; iy++) {
      npoly->expon[nt * npoly->nind + iy] =
           poly->expon[ix * poly->nind + iy];
    }
    npoly->expon[nt * poly->nind + ivar] = 0;
    value = 1.0 / (poly->expon[ix * poly->nind + ivar] + 1.0);
    for (iy = 0; iy < nt; iy++) {
      for (iz = 0; iz < npoly->nind; iz++) {
        if (npoly->expon[iy * npoly->nind + iz] !=
            npoly->expon[nt * npoly->nind + iz]) {
          break;
	}
      }
      if (iz == npoly->nind) {
        nt = iy;
      }
    }
    daxpy_ (&poly->ndep, &value, &poly->coefs[ix], &poly->nterm,
            &npoly->coefs[nt], &poly->nterm);
    if (nt == npoly->nterm) {
      npoly->nterm += 1;
    }
  }

/* Compress the number of terms */

  for (ix = 1; ix < npoly->ndep; ix++) {
    dcopy_ (&npoly->nterm, &npoly->coefs[(ix - 1) * poly->nterm],
            &one, &npoly->coefs[(ix - 1) * npoly->nterm], &one);
  }
  B_REALLOC (npoly->coefs, double, npoly->nterm * npoly->ndep,
             bytes, ier, END);

/* Return the integrated function */

END:
  return ier;
}
