/*********************************************************************/
/*        LINEAR TREE for Supervised Learning                        */
/*        Versao 1.0 (10/12/1997)                                    */
/*        Developed by: Joao Gama                                    */
/*                LIACC - Uni.do Porto                               */
/*                jgama@ncc.up.pt                                    */
/*-------------------------------------------------------------------*/
/*  File: utils.c                                                    */
/*********************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include "utils.h"

#define _MAX_WORD_LEN_ 5024
#define _MAX_SIZE_LINE_ 5024
#define end_of_record(ch) ((ch == EOF) || (ch == '\n'))

int contained(char ch,char *p);
static char *ReadWord(char **str, char *sep);
/******************************************/
/*      Parse a Command Line              */
/******************************************/
int mygetopt(int Argc, char **Argv,char *Str, char **optarg)
{
  static int optind = 1;
  int Optchar;
  char *Option;
  
  if ( optind >= Argc ) return EOF;
  Option = Argv[optind++];
  if ( *Option++ != '-' ) return '?';
  Optchar = *Option++;
  while ( *Str && *Str != Optchar ) Str++;
  if ( ! *Str ) return '?';
  if ( *++Str == ':' ) {
    if ( *Option ) *optarg = Option;
    else
      if ( optind < Argc )    *optarg = Argv[optind++];
      else                    Optchar = '?';
  }
  return Optchar;
}

List *insert(void *element, List *lst)
{
  List *newptr = (List *) malloc(sizeof(List));
  if (! newptr)
    fprintf(stderr, "lists.c:insert: Out of memory!\n");
  else {
    newptr->data = element;
    newptr->next = lst;
  }
  return(newptr);
}
int empty_s(Stack *st)
{
  if (!st || st->list == NULL) return 1;
  return 0;
}


Stack *push(void *element, Stack *st)
{
  if (!st) {
    st = (Stack *)malloc(sizeof(Stack));
    st->list = NULL;
  }
  st->list = insert(element, st->list);
  return(st);
}

void *pop(Stack *st)
{
  void *dt = NULL;
  List *temp;

  if (!empty_s(st)){
    dt = top_of_stack(st);
    temp = st->list;
    st->list = tail(st->list);
    free(temp);
  }
  return(dt);
}



/* =================================================================
   Reads an array of arrays of words
   Each line is an array of words
   ================================================================= */
char ***_ReadFile(FILE *fi, long *nrt, int **nr_valores, long nr, char *fld_sep)
{
  char **linha, ***fich;
  int nrl = 0;

  if(feof(fi)) {
    if (nr > 1) {
      fich = (char ***) malloc((nr-1) * sizeof(char **));
      *nr_valores = (int *) calloc(nr, sizeof(int));
      *nrt = nr - 1;
      return --fich;
    }
    return NULL;
  }
  if ((linha = _ReadLine(fi, &nrl, 1,fld_sep)) != NULL) {
    fich = _ReadFile(fi, nrt, nr_valores, nr+1,fld_sep);
    fich[nr] = linha;
    nr_valores[0][nr] = nrl; 
    return fich;
  }
  return _ReadFile(fi, nrt, nr_valores, nr,fld_sep);
}
/* =================================================================
   Reads a array of words from one line of a file.
   Input -  FILE *fi, &nrt
   Output - char **
            nrt - nr. of words
   ================================================================= */
char **_ReadLine(FILE *fi, int *nrt, int nr, char *fld_sep)
{
  char *word, **arr_str;

  if(feof(fi) || ((word = ReadField(fi, fld_sep)) == NULL)) {
    if (nr > 1) {
      *nrt = nr - 1;
      arr_str = (char **) malloc((nr-1) * sizeof(char *));
      return --arr_str;
    }
    return NULL;
  }
  arr_str = _ReadLine(fi, nrt, nr+1,fld_sep);
  arr_str[nr] = word;
  return arr_str;
}

char *ReadField(FILE *fi, char *sep)
{
  register int i = 0;
  char temp[_MAX_SIZE_LINE_], ch, lch;
  char *field;
  
  ch = lch = *sep;
  while (contained(ch, sep))      ch = getc(fi);
  if (end_of_record(ch))          return(NULL);

  while(TRUE) { 
    if (end_of_record(ch) || contained(ch, sep)) {
      if (!contained(lch, sep)) {
        if (temp[i-1] == '.') --i;
        temp[i++] = '\0';
        field = new_strcpy(temp);
        if (end_of_record(ch))  ungetc(ch, fi);
       return(field);
      }
    }
    else
      temp[i++] = ch;
    lch = ch;
    ch = getc(fi);
  }
}
/*********************************************************************
        String utilities								     
**********************************************************************/
/* =================================================================
   This function consumes a string from another until a separator is
   reached.
   ================================================================= */
static char *ReadWord(char **str, char *sep)
{
  register int i = 0;
  char temp[256], ch;
  
  ch = **str;;
  while (*str && contained(ch, sep))      { (*str)++; ch = **str;}
  if (ch != '\0') {
    while ((!contained(ch,sep)) && (ch)) {
      temp[i++]=ch;
      (*str)++;
      ch = **str;
    }
    temp[i]='\0';
    return(new_strcpy(temp));
  }
  return NULL;
}

char **_v_split(char *str, char *splits, int *nwrds, int nr)
{
  char *word, **arr_str;

  if ((!(*str)) || ((word=ReadWord(&str,splits)) == NULL)) {
    if (nr > 1) {
      *nwrds = nr - 1;
      arr_str = (char **) malloc((nr - 1) * sizeof(char*));
      return --arr_str;
    } 
    else return NULL;
  }
  arr_str = _v_split(str,splits,nwrds,nr+1);
  arr_str[nr] = word;
  return arr_str;
}

/************************************************/
/*	new_strcpy(str)				*/
/*	Return a pointer to a new location 	*/
/*		of str				*/
/************************************************/
char *new_strcpy(char *str)
{
  char *p, *n;
  
  n = (char *) calloc(strlen(str)+1, sizeof(char));
  
  p = n;
  while(*str) *n++ = *str++;
  *n = '\0';
  return(p);
}

/************************************************/
/*	new_strcat(str1, str2)			*/
/*	Return a pointer to a string that 	*/
/*		concatenates str1 with str2	*/
/************************************************/
char *new_strcat(char *str1, char *str2)
{
  char *p;
  char *str = (char *) calloc(strlen(str1)+strlen(str2)+1, sizeof(char));
  
  p = str;
  while(*str1) *str++ = *str1++;
  while(*str2) *str++ = *str2++;
  *str = '\0';
  return(p);
}

/* =================================================================
   Checking if a character is contained in a string.
   1 - yes; 0 - no
   ================================================================= */
/************************************************/
/*	is_a_int(str)				*/
/*	Return 	1 if all characters in str 	*/
/*		are numbers, 0 Otherwise	*/
/************************************************/
int is_a_int(char *str)
{
  if ((*str == '+') || (*str == '-'))	++str;
  if (!*str)   return(0);
  while(*str) {
    if ((*str < '0') || (*str > '9'))
      return(0);
    ++str;
  }
  return(1);
}

int contained(char ch,char *p)
{
  while ((*p) && (*p != ch)) p++;
  if (*p) return(1);
  return(0);
}

unsigned int all_integers(char **s, unsigned int n)
{
  register unsigned int i;
  for(i = 1; i <= n; i++) if (!is_a_int(s[i])) return FALSE;
  return TRUE;
}

int compare_chars(char **s1, char **s2)
{
  return atoi(*s1) - atoi(*s2);
}

/* ******************************************* */
/* Functions for vector and matrix             */
/* Memory Allocation                           */
/* Based on "Numerical Recipes in C            */
/* ******************************************* */
int **imatrix(long nrl,long nrh, long ncl, long nch)
/* allocate a int matrix m[nrl..nrh][ncl..nch]  */
{
  long i, nrow = nrh - nrl+1, ncol = nch-ncl+1;
  int **m;
  
  m = (int **)  malloc((size_t) nrow * sizeof(int *));
  if (!m)       fprintf(stderr, "E)imatrix:Out of memory!\n");
  else {
    m -= nrl;
    m[nrl] = (int *) calloc((size_t) nrow*ncol, sizeof(int));
    if (!m[nrl])     fprintf(stderr, "E)imatrix: Out of memoy!\n");
    else {
      m[nrl] -= ncl;
      for(i = nrl+1; i<= nrh; i++) m[i]=m[i-1]+ncol;
    }
  }
  return m;
}

double **dmatrix(long nrl,long nrh, long ncl, long nch)
/* allocate a double matrix m[nrl..nrh][ncl..nch]       */
{
  long i, nrow = nrh - nrl+1, ncol = nch-ncl+1;
  double **m;
  
  m = (double **) calloc((size_t) nrow,  sizeof(double *));
  if (!m)       fprintf(stderr, "E)dmatrix:Out of memory!\n");
  else {
    m -= nrl;
    m[nrl] = (double *) calloc((size_t) nrow*ncol, sizeof(double));
    if (!m[nrl])        fprintf(stderr, "E)dmatrix: Out of memoy!\n");
    else {
      m[nrl] -= ncl;
      for(i = nrl+1; i<= nrh; i++) m[i]=m[i-1]+ncol;
    }
  }
  return m;
}

double *dvector(long nrl, long nrh)
{
  double *v;

  v = (double *)        calloc((size_t) (nrh - nrl +1), sizeof(double));
  if (!v)               fprintf(stderr, "E)fvector: Out of memory !");
  return(v-nrl);
}

void free_dvector(double *v, long nl, long nh)
{
  free((double *) (v + nl)); 
}

void free_dmatrix(double **m, long nrl, long nrh, long ncl, long nch)
{
  free((double *) (m[nrl]+ncl));
  free((double **) (m+nrl)); 
}



int *ivector(long nrl, long nrh)
{
  int *v;

  v = (int *)   calloc((size_t) (nrh - nrl +1), sizeof(int));
  if (!v)               fprintf(stderr, "E)fvector: Out of memory !");
  return(v-nrl);
}

void free_ivector(int *v, long nl, long nh)
{
  free((int *) (v + nl)); 
}

void free_imatrix(int **m, long nrl, long nrh, long ncl, long nch)
{
  free((int *) (m[nrl]+ncl));
  free((int **) (m+nrl)); 
}

void ShowMatrix(double **m, int n0, int n, int l0, int l)
{
  register int k, j;

  for(j = l0; j <= l; j++) printf("\t[%d]", j);
  printf("\n");
  for(j = n0; j <= n; j++) {
    printf("[%d]\t", j);
    for(k = l0; k <= l; k++) 
      printf("%.3f\t", m[j][k]);
    printf("\n");
  }
}

void ShowIMatrix(int **m, int n0, int n, int l0, int l)
{
  register int k, j;

  for(j = l0; j <= l; j++) printf("\t[%d]", j);
  for(j = n0; j <= n; j++) {
    printf("\n[%d]", j);
    for(k = l0; k <= l; k++) 
      printf("\t%d", m[j][k]);
  }
  printf("\n");
}











