/*********************************************************************/
/*        LINEAR TREE for Supervised Learning                        */
/*        Versao 1.0 (10/12/1997)                                    */
/*        Developed by: Joao Gama                                    */
/*                LIACC - Uni.do Porto                               */
/*                jgama@ncc.up.pt                                    */
/*-------------------------------------------------------------------*/
/*  FILE: distributions.c                                            */
/*********************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "Ci_instances.h"
#include "distributions.h"
#include "utils.h"
/****************************************/
/*   Prototyps for Private FUNCTIONS    */
/****************************************/
static double ***init_stat(DomainInfo *domain, int nr_cl, int nr_at);
static void compute_stat_exemplo(DomainInfo *domain, double ***STATIS, AttrVal *exemplo, double weight, int classe, int nr_att);
static void compute_means(DomainInfo *domain, double ***STATIS, double *class_freq, int nr_att);

#define MAX_STR_SIZE 128
/****************************************/
/*   Public FUNCTIONS                   */
/****************************************/
/**************************************************/
/* Return  STATIS matrix                          */
/* Fill class_distribution                        */
/**************************************************/
double ***My_Distribuitions\
(CiDs *ds, long int low, long int high, int nr_att, double **class_dist)
{
  register long int i, classe;
  double weight, *class_freq, ***stats;
  AttrVal *instance;

  if ((class_freq = (double *) calloc(Ci_NrClasses(ds->domain) + 1, sizeof(double))) != NULL) {
    if ((stats = init_stat(ds->domain, Ci_NrClasses(ds->domain), nr_att)) != NULL) {
      for(i = low; i <= high; i++) {
	instance = Ci_AttVal(ds, i);
	classe = Ci_Classe(Ci_Example(ds, i));
	weight = Ci_Weight(Ci_Example(ds, i));
	class_freq[classe] += weight;
	class_freq[0] += weight;
        compute_stat_exemplo(ds->domain, stats, instance, weight, classe, nr_att);
      }
      compute_means(ds->domain, stats, class_freq,  nr_att);
      *class_dist = class_freq;
      return stats;
    }
  }
  fprintf(stderr, "compute_stats: Out of memory\n");
  return NULL;
}
  
void ShowMyDistributions(DomainInfo *domain, double ***STATIS, int nr_att)
{
  register int i, j, k;

  for(j = 1; j <= nr_att; j++) {
    if (j > NrAttrs(domain))
      printf("Attribute Linear_%d - type %d\n", j, CiTypeAttr(domain, j));
    else
      printf("Attribute %s - type %d\n", NameAttr(domain, j), CiTypeAttr(domain, j));
    printf("\tUnk");
    switch (CiTypeAttr(domain, j)) {
    case continuous: 
      printf("\tMean");
      break;
    case ordered: 
    case integer: 
      for(k = 1; k <= NValsAttr(domain, j); k++)
	printf("\t[%.5s]", LblValId(domain, j, k));
      printf("\tMean");
      break;
    case nominal:
      for(k = 1; k <= NValsAttr(domain, j); k++)
	printf("\t[%.5s]", LblValId(domain, j, k));
    }
    for(i = 0; i <= Ci_NrClasses(domain); i++) {
      if (!i)
	printf("\n[DS]");
      else
	printf("\n[%.5s]", LblValId(domain, 1+NrAttrs(domain), i));
      switch (CiTypeAttr(domain, j)) {
      case continuous: 
        printf("\t%.3f\t%.3f", STATIS[j][i][0], STATIS[j][i][1]);
        break;
      case integer:
      case ordered: 
        for(k = 0; k <= NValsAttr(domain, j); k++)
          printf("\t%.3f", STATIS[j][i][k]);
        printf("\t%.3f", STATIS[j][i][1+NValsAttr(domain, j)]);
        break;
      case nominal:
        for(k = 0; k <= NValsAttr(domain, j); k++)
          printf("\t%.3f", STATIS[j][i][k]);
      }
    }
    printf("\n");
  }
}

void ShowDistrClass(DomainInfo *domain, double *dist)
{
  register int i;

  printf("Class Distribution\n");
  for(i = 0; i <= Ci_NrClasses(domain); i++)
    printf("%d: %.3f\t", i, dist[i]);
  printf("\n");
}

void free_stats(DomainInfo *domain, double ***stats, int nr_cl, int nr_at)
{
  register int i;

  for(i = 1; i <= nr_at; i++) {
    switch(CiTypeAttr(domain, i)) {
    case nominal:
      free_dmatrix(stats[i], 0, nr_cl, 0, 1 + NValsAttr(domain, i));
      break;
    case integer:
    case ordered:
      free_dmatrix(stats[i], 0, nr_cl, 0, 1 + NValsAttr(domain, i));
      break;
    case continuous:
      free_dmatrix(stats[i], 0, nr_cl, 0, 1);
      break;
    }
  }
  free(++stats);
}
/****************************************/
/*   Private FUNCTIONS                  */
/****************************************/
static double ***init_stat(DomainInfo *domain, int nr_cl, int nr_at)
{
  register int i;
  double ***stat, **att = NULL;

  stat = (double ***) malloc((int) nr_at * sizeof(double **));
  --stat;
  for(i = 1; i <= nr_at; i++) {
    switch(CiTypeAttr(domain, i)) {
    case nominal:
      att = dmatrix(0, nr_cl, 0, 1 + NValsAttr(domain, i));
      break;
    case integer:
    case ordered:
      att = dmatrix(0, nr_cl, 0, 1 + NValsAttr(domain, i));
      break;
    case continuous:
      att =  dmatrix(0, nr_cl, 0, 1);
      break;
    }
    stat[i] = att;
  }
  return stat;
}

static void compute_stat_exemplo\
(DomainInfo *domain, double ***STATIS, AttrVal *exemplo, double weight, int classe, int nr_att)
{
  register int j, pos, valor;
  char dummy[MAX_STR_SIZE];
  double dvalor;
  
  for(j = 1; j <= nr_att; j++) { 
    if (NormalVal(exemplo[j])) {
      switch (CiTypeAttr(domain, j)) {
      case continuous:  
	dvalor = CValAttEx(exemplo, j);
	STATIS[j][0][1] += dvalor;
	STATIS[j][classe][1] += dvalor;
	break;
      case integer:
      case ordered:
	valor = DValAttEx(exemplo, j);
	sprintf(dummy, "%d", valor);
	pos = IdValLbl(domain, j, dummy);

	STATIS[j][0][pos] += weight;
	STATIS[j][classe][pos] += weight;
	
	STATIS[j][0][1+NValsAttr(domain, j)] += valor;
	STATIS[j][classe][1+NValsAttr(domain, j)] += valor;
	break;
      case nominal: 
	valor = DValAttEx(exemplo, j);
	STATIS[j][0][valor] += weight;
	STATIS[j][classe][valor] += weight;

	STATIS[j][0][1 + NValsAttr(domain, j)] += valor;
	STATIS[j][classe][1 + NValsAttr(domain, j)] += valor;
      }
    }
    else {
      STATIS[j][0][0] += weight;
      STATIS[j][classe][0] += weight;
    }
  }
}

/****************************************/
/*   Medias e Desvios FUNCTIONS         */
/****************************************/
static void compute_means\
(DomainInfo *domain, double ***STATIS, double *class_freq, int nr_att)
{
  register int i,j;

  for(j = 1; j <= nr_att; j++) {
    switch(CiTypeAttr(domain, j)) {
    case continuous:
      for(i = 0; i <= Ci_NrClasses(domain); i++)  
	if (class_freq[i]) STATIS[j][i][1] /= class_freq[i];
      break;
    case integer:
    case ordered:
    case nominal:
      for(i = 0; i <=  Ci_NrClasses(domain); i++)   
        if (class_freq[i]) STATIS[j][i][1+NValsAttr(domain, j)] /= class_freq[i];
    }
  }
}

