/*********************************************************************/
/*        LINEAR TREE for Supervised Learning                        */
/*        Versao 1.0 (10/12/1997)                                    */
/*        Developed by: Joao Gama                                    */
/*                LIACC - Uni.do Porto                               */
/*                jgama@ncc.up.pt                                    */
/*-------------------------------------------------------------------*/
/*   FILE:BuildTree.h                                                */  
/*********************************************************************/
#ifndef _BUILDTREEHEADER
#define _BUILDTREEHEADER
#include "Ci_instances.h"
#include "tree.h"

typedef struct _data {
  double *class_distribution;
  double *acum_class_distr;
  int nr_att;
  int nr_rows;
  int nr_columns;
  double **coeficientes;
  double node_errors;
  double tree_errors;
  int split_att;
  double split_value;
}Data;

#define CLASS_DIST(D)          (D->class_distribution)
#define ACUM_CLASS_DIST(D)     (D->acum_class_distr)
#define NR_ATT(D)              (D->nr_att)
#define COEFICIENTS(D)         (D->coeficientes)
#define COLUMNS(D)             (D->nr_columns)
#define ROWS(D)                (D->nr_rows)
#define DERRORS(D)             (D->node_errors)
#define SPLIT_ATT(D)           (D->split_att)
#define SPLIT_VALUE(D)         (D->split_value)
#define TREE_ERRORS(D)         (D->tree_errors)

Tree *BuildTree(CiDs *ds, long int Low, long int High, int nr_att, TreeInfo *treeinfo);
void ShowTree(DomainInfo *domain, Data *data, int nr, TYPE_NODE t);
int WriteData(int fd, Data *data, int nr_cl);
void *ReadData(int fd, int nr_cl);
int PruneTree(DomainInfo *domain, Data *data, double **distrib);
void Show_Coeficients(DomainInfo *domain, Tree *tree);
double CodeLtree(DomainInfo *domain, Data *data, TYPE_NODE t);
int RemoveCoefficients(DomainInfo *domain, Tree *tree, int nr_att);
#endif


