/* ==========================================================================
  
        FFFFF  RRRR   EEEEE  EEEEE  FFFFF   OOOO   RRRR   M    M 
        F      R   R  E      E      F      O    O  R   R  MM  MM 
        FFF    RRRR   EEE    EEE    FFF    O    O  RRRR   M MM M 
        F      R  R   E      E      F      O    O  R  R   M    M 
        F      R   R  E      E      F      O    O  R   R  M    M 
        F      R   R  EEEEE  EEEEE  F       OOOO   R   R  M    M 
  
  
             SSSSS  PPPPP   L      III  N    N  EEEEE   SSSSS    
            S       P    P  L       I   NN   N  E      S
             SSSS   PPPP    L       I   N N  N  EEE     SSSS
                 S  P       L       I   N  N N  E           S
                 S  P       L       I   N   NN  E           S
            SSSSS   P       LLLLL  III  N    N  EEEEE  SSSSS 
  
   ==========================================================================
    
     Project:      "Freeform splines software package" of 
  
                       University of Karlsruhe (TH)
                       Institute for Operating and Dialog Systems
                       Research Group on Computer Aided Geometric Design
                       Head of research group: Prof. Dr. H. Prautzsch
                       WWW: http:  i33www.ira.uka.de
  
  
     Program name: subdivide
  
     Version:      1.1
  
     Author:       Stephan Bischoff
    
     Date:         September, 1999
  
     Usage:        subdivide BEZ-FILE-1 BEZ-FILE-2
  
     Description:  The program reads BEZ-FILE-1, subdivides the patches
                   in (0.5, 0.5) and writes them to BEZ-FILE-2. It can
		   handle patches up to bidegree (15,15). Patches of 
		   bidegree > (9,9) are given in hexadecimal notation, e.g.
                          BEZDD3
		   means a patch of bidegree (13,13).

     Contact:      Please let use hear from you in case you have any 
                   suggestions or problems with our software:
                          prau@ira.uka.de
                          umlauf@ira.uka.de
  
*/

#include <math.h>
#include <iostream.h>
#include <stdlib.h>
#include <ctype.h>
#include "scanner.c"  /* created by flex  */
  
/* fehler : returns an error message and aborts the programme */
void fehler(char *file_name, char *message)
{
  fprintf(stderr, "%s : %d : %s\n", file_name, line_no, message);
  fclose(outfile);
  remove(file_name);
  exit(1);
}
 
/* get_numbers : tries to read n numbers */
int get_numbers(int n)
{
  for ( ; n > 0; n--) 
    if ((tok = yylex()) != TOK_NUMBER) return 0;
  return 1;
}

/*
 *         main
 */

int main(int argc, char **argv)
{
  int i, j, k, d, x, y, patch = 1;
  double b[4][100][100];

  if (argc != 3) {
      fprintf(stderr, "Usage : %s BEZ-FILE-1 BEZ-FILE-2\n", argv[0]);
      fprintf(stderr, "Subdivides the patches in BEZ-FILE-1 and writes the resul\n");
      fprintf(stderr, "to BEZ-FILE-2.\n");
      fprintf(stderr, "For details refer to the documentation in user_manual.ps.\n");
      return 1;
    }
  
  /* open infile */
  if ((yyin = fopen(argv[1], "r")) == NULL) {
    printf("%s : can't open %s for reading\n", argv[0], argv[1]);
    return 1;
  }

  /* open outfile */
  if ((outfile = fopen(argv[2], "w")) == NULL) {
    printf("%s : can't open %s for writing\n", argv[0], argv[2]);
    fclose(yyin);
    return 1;
  }

  /* write info-header */
  fprintf(outfile, "# This is the subdivided Bezier surface of %s\n", argv[1]);
  fprintf(outfile, "# Generated by the command : ");
  for (i = 0; i < argc - 1; i++)
    fprintf(outfile, "%s ", argv[i]);
  fprintf(outfile, "%s\n", argv[argc - 1]);

  /* main loop */
  tok = yylex();
  while (tok == TOK_BEZ) {

    tok = TOK_NUMBER;
    while (tok == TOK_NUMBER) {
      
      /* read the Bezier points */
      for (i = 0; i < degree_x + 1; i++)
	for (j = 0; j < degree_y + 1; j++)
	  for (d = 0; d < dimension; d++)
	    if ((tok = yylex()) == TOK_NUMBER)
	      b[d][i][j] = atof(yytext);
	    else 
	      fehler(argv[1], "number expected (Bezier component)");	      
      
      /* throw away the texture and colour information */
      if (texture && !get_numbers(16)) fehler(argv[1], "number expected (texture component)");           
      if (colour  && !get_numbers(16)) fehler(argv[1], "number expected (colour component)");

      /* subdivide the Bezier net in x = y = 0.5 */
      for (d = 0; d < dimension; d++)
	{
	  for (y = 0; y < degree_y + 1; y++)
	    for (i = 0; i < degree_x + 1; i++)
	      {
		b[d][2 * degree_x - i][y] = b[d][degree_x][y];
		for (j = degree_x; j > i; j--)
		  b[d][j][y] = (b[d][j][y] + b[d][j-1][y]) / 2.0;
	      }
	  
	  for (x = 0; x < 2 * degree_x + 1; x++)
	    for (j = 0; j < degree_y + 1; j++)
	      {
		b[d][x][2 * degree_y - j] = b[d][x][degree_y];
		for (i = degree_y; i > j; i--)
		  b[d][x][i] = (b[d][x][i] + b[d][x][i-1]) / 2.0;
	      }
	}

      /* write the Bezier points */

      fprintf(outfile, "# patch %d\n", patch++);
      fprintf(outfile, "BEZ%X%X%d\n", degree_x, degree_y, dimension);
      
      for (i = 0; i < degree_x + 1; i++)
	for (j = 0; j < degree_y + 1; j++) {
	  for (d = 0; d < dimension; d++)
	    fprintf(outfile, "%f ", b[d][i][j]);
	  fprintf(outfile, "\n");
	}
      
      fprintf(outfile, "# patch %d\n", patch++);
      fprintf(outfile, "BEZ%X%X%d\n", degree_x, degree_y, dimension);
      
      for (i = 0; i < degree_x + 1; i++)
	for (j = degree_y; j < 2 * degree_y + 1; j++) {
	  for (d = 0; d < dimension; d++)
	    fprintf(outfile, "%f ", b[d][i][j]);
	  fprintf(outfile, "\n");
	}
      
      fprintf(outfile, "# patch %d\n", patch++);
      fprintf(outfile, "BEZ%X%X%d\n", degree_x, degree_y, dimension);
      
      for (i = degree_x; i < 2 * degree_x + 1; i++)
	for (j = 0; j < degree_y + 1; j++) {
	  for (d = 0; d < dimension; d++)
	    fprintf(outfile, "%f ", b[d][i][j]);
	  fprintf(outfile, "\n");
	}
      
      fprintf(outfile, "# patch %d\n", patch++);
      fprintf(outfile, "BEZ%X%X%d\n", degree_x, degree_y, dimension);
      
      for (i = degree_x; i < 2 * degree_x + 1; i++)
	for (j = degree_y; j < 2 * degree_y + 1; j++) {
	  for (d = 0; d < dimension; d++)
	    fprintf(outfile, "%f ", b[d][i][j]);
 	  fprintf(outfile, "\n");
	}
      
      fprintf(outfile, "\n");
      if ((tok = yylex()) == TOK_NUMBER) yyless(0);
    }
  }
  
  if (tok != TOK_EOF) 
    fehler(argv[1], "syntax error");

  /* no errors occured */
  fclose(yyin);
  fclose(outfile);
  return 0;
}



