// ==========================================================================
//
//      FFFFF  RRRR   EEEEE  EEEEE  FFFFF   OOOO   RRRR   M    M 
//      F      R   R  E      E      F      O    O  R   R  MM  MM 
//      FFF    RRRR   EEE    EEE    FFF    O    O  RRRR   M MM M 
//      F      R  R   E      E      F      O    O  R  R   M    M 
//      F      R   R  E      E      F      O    O  R   R  M    M 
//      F      R   R  EEEEE  EEEEE  F       OOOO   R   R  M    M 
//
//
//           SSSSS  PPPPP   L      III  N    N  EEEEE   SSSSS    
//          S       P    P  L       I   NN   N  E      S
//           SSSS   PPPP    L       I   N N  N  EEE     SSSS
//               S  P       L       I   N  N N  E           S
//               S  P       L       I   N   NN  E           S
//          SSSSS   P       LLLLL  III  N    N  EEEEE  SSSSS 
//
// ==========================================================================
//  
//   Project:      "Freeform splines software package" of 
//
//                     University of Karlsruhe (TH)
//                     Institute for Operating and Dialog Systems
//                     Research Group on Computer Aided Geometric Design
//                     Head of research group: Prof. Dr. H. Prautzsch
//                     WWW: http://i33www.ira.uka.de
//
//
//   Class name:   vec3D
//
//   Parents:      --
//
//   Version:      1.1
//
//   Author:       Thomas Mueller
//  
//   Date:         July, 1997
//
//   Description:  Implements a basic 3D vector class with matrix multiplication,
//                 assignment, indexing operations and a cutting function.
//                 (z,1) matrices are understood as vectors. 
//                
//
//   Contact:      Please let use hear from you in case you have any 
//                 suggestions or problems with our software:
//                        prau@ira.uka.de
//                        umlauf@ira.uka.de
//


// --------------------------------------------------------------------------
//
//                  CLASS DECLARATION
//
// --------------------------------------------------------------------------
class vec3d
{
private:
  double coord[3];    // coordinates

public:
  
  // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  // Constructors:
  //

  // Construct 3D 0-vector.
   vec3d(){
    coord[0] = coord[1] = coord[2] = 0;
  }
  
  // Construct vector (c0,c1,c2).
  vec3d(double c0, double c1, double c2){
      coord[0] = c0;
      coord[1] = c1;
      coord[2] = c2;
  }
  

  // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  // Operator:
  //

  // Indexing-Operator: i-th coordinate
  double & operator[](int);
};



// --------------------------------------------------------------------------
//
//                  OPERATOR DEFINITIONS
//
// --------------------------------------------------------------------------

// Indexing-Operator: i-th coordinate
inline double & vec3d::operator[](int i)
{
  return coord[i];
}
