#
# (C) Tenable Network Security

if(description)
{
 script_id(11760);
 script_version ("$Revision: 1.2 $");
 script_bugtraq_id(7933);
 
 name["english"] = "Pod.Board Forum_Details.PHP Cross Site Scripting";
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is hosting the Pod.Board CGI suite,
a set of PHP scripts designed to manage online forums.

There is a cross site scripting issue in this suite which
may allow an attacker to steal the cookies of your legitimate
users, by luring them into clicking on a rogue URL.

Solution : None at this time
Risk Factor : Low/Medium";


 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for Pod.Board XSS";
 
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 
 script_copyright(english:"This script is Copyright (C) 2003 Tenable Network Security");
 family["english"] = "CGI abuses";
 script_family(english:family["english"]);
 script_dependencie("find_service.nes", "http_version.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}


include("http_func.inc");
include("http_keepalive.inc");


port = get_kb_item("Services/www");
if(!port) port = 80;

if(!get_port_state(port))exit(0);


dirs = make_list("", cgi_dirs());

foreach d (dirs)
{
 req = http_get(item:d+"/forum_details.php?user_nick=<script>foo</script>", port:port);
 res = http_keepalive_send_recv(port:port, data:req);
 
 if ( res == NULL ) exit(0);
 

 if(egrep(pattern:"HTTP/.* (200|302) .*", string:res) &&
    "<script>foo</script>" >< res )
 {
	security_warning(port);
	exit(0);
 }
}
