/* Nessus
 * Copyright (C) 1998 - 2001 Renaud Deraison
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2,
 * as published by the Free Software Foundation
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * In addition, as a special exception, Renaud Deraison
 * gives permission to link the code of this program with any
 * version of the OpenSSL library which is distributed under a
 * license identical to that listed in the included COPYING.OpenSSL
 * file, and distribute linked combinations including the two.
 * You must obey the GNU General Public License in all respects
 * for all of the code used other than OpenSSL.  If you modify
 * this file, you may extend this exception to your version of the
 * file, but you are not obligated to do so.  If you do not wish to
 * do so, delete this exception statement from your version.
 *
 * Signals handlers
 */

#include <includes.h>


#ifndef NESSUSNT
#include "log.h"
#include "auth.h"
#include "sighand.h"
#include "utils.h"

#ifdef HAVE_SYS_WAIT_H
#include <sys/wait.h>
#endif
#ifdef HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif
#ifdef HAVE_SYS_RESOURCE_H
#include <sys/resource.h>
#endif

extern pid_t bpf_server_pid;


/* do not leave a zombie, hanging around if possible */
void
let_em_die
  (int pid)
{
  int	status, x;
# ifdef HAVE_WAITPID
  x = waitpid (pid, &status, WNOHANG) ;
# else
# ifdef HAVE_WAIT3
  struct rusage ru ;
# ifdef HAVE_WAIT4
  x = wait4 (pid, &status, WNOHANG, &ru) ;
# else
  x = wait3 (&status, WNOHANG, &ru) ;
# endif
# endif /* HAVE_WAIT3 */
# endif /* HAVE_WAITPID */
}


void
make_em_die
  (int sig)
{
  /* number of times, the sig is sent at most */
  int n = 3 ;
  
# ifdef DEBUG
  extern int single_shot ;
  if (single_shot)
    return ;
# endif

  /* leave if we are session leader */
  if (getpgrp () != getpid()) return ;
  
   
   if(bpf_server_pid != 0 && kill(bpf_server_pid, 0) >= 0)
   	kill(bpf_server_pid, SIGTERM);

  /* quickly send siglals and check the result */
  if (kill (0, sig) < 0) return ;	     
  let_em_die (0);
  if (kill (0, 0) < 0) return ;

  do {
    /* send the signal to everybody in the group */
    if (kill (0, sig) < 0)
      return ;	     
    sleep (1);
    /* do not leave a zombie, hanging around if possible */
    let_em_die (0);
  } while (-- n > 0) ;

  if (kill (0, 0) < 0)
    return ;

  kill (0, SIGKILL);
  sleep (1);
  let_em_die (0);
}

/*
 *  Replacement for the signal() function, written
 *  by Sagi Zeevi <sagiz@yahoo.com>
 */
void (*nessus_signal(int signum, void (*handler)(int)))(int)
{
  struct sigaction saNew,saOld;

  /* Init new handler */
  sigfillset(&saNew.sa_mask);
  sigdelset(&saNew.sa_mask, SIGALRM); /* make sleep() work */
  
  saNew.sa_flags = 0;
# ifdef HAVE_SIGNAL_SA_RESTORER
  saNew.sa_restorer = 0; /* not avail on Solaris - jordan */
# endif
  saNew.sa_handler = handler;

  sigaction(signum, &saNew, &saOld);
  return saOld.sa_handler;
}

void sighand_pipe()
{
  log_write("connection closed by the client (SIGPIPE caught)\n");
  shutdown (0,2);
  close (0);
  make_em_die (SIGTERM);
  _EXIT(1);   
}

void sighand_chld()
{
 int ret; 
 wait(&ret);
}

void sighand_alarm()
{
  log_write("connection timed out\n");
  shutdown (0,2);
  close (0);
  make_em_die (SIGTERM);
  _EXIT(1);   
}           



void sighandler(sign)
 int sign;
{
 char * sig = NULL;
 int murderer = 0;
 
 switch(sign)
 {
  case SIGTERM:
  	sig = "TERM";
	murderer++;
	delete_pid_file();
  	break;
  case SIGUSR1 :
 	sig = "USR1";
	delete_pid_file();
 	break;
  case SIGINT :
  	sig = "INT";
	delete_pid_file();
	murderer++;
	break;
  case SIGSEGV :
#ifdef HAVE__EXIT
	signal(SIGSEGV, _exit);
#else
  	signal(SIGSEGV, exit);
#endif	
  	sig = "SEGV";
	break;
  default:
  	sig = "< signal nonsense >";
 }
 
 log_write("received the %s signal\n",sig);
 
#ifndef USE_AF_INET
  unlink(AF_UNIX_PATH);
#endif


 if(murderer)
  make_em_die(sign);
  
 
 
  
 _EXIT(0);
}



void sighand_segv()
{
#ifdef HAVE__EXIT
 signal(SIGSEGV, _exit);
#else
 signal(SIGSEGV, exit);
#endif
 log_write("SIGSEGV occured !\n");
#if 0
 for (;;) nice(1);		/* to attach a debugger! */
#endif
 make_em_die (SIGTERM);
 _EXIT(0);
}


#endif /* not defined(NESSUSNT) */
