OBJS=New.o stack.o array.o linked_list.o hash.o
DEBUG_OBJS=New_debug.o stack_debug.o array_debug.o list_debug.o hash_debug.o
INTERNAL_OBJS=list_int.o hash_int.o list_int_deb.o hash_int_deb.o

DEBUG_LIB=-lhash_debug -llist_debug -larray -lstack -lNew

# Modify these for you own system
SYSTYPE=SUNOS
INCLUDES=$(HOME)/struct/include
LIBRARIES=$(HOME)/struct/lib

LIBDIR=-L$(LIBRARIES)
INCDIR=-D$(SYSTYPE) -I$(INCLUDES)
CFLAGS=$(INCDIR) -O
ARFLAGS= cr 

CC=gcc

libs: $(OBJS) $(DEBUG_OBJS) $(INTERNAL_OBJS)
	$(AR) $(ARFLAGS)  libstruct.a New.o stack.o array.o linked_list.o hash.o
	ranlib libstruct.a

	$(AR) $(ARFLAGS)  libNew.a New.o
	ranlib libNew.a
	
	$(AR) $(ARFLAGS)  libNew_debug.a New_debug.o
	ranlib libNew_debug.a
	
	$(AR) $(ARFLAGS)  libstack.a stack.o
	ranlib libstack.a
	
	$(AR) $(ARFLAGS)  libstack_debug.a stack_debug.o
	ranlib libstack_debug.a

	$(AR) $(ARFLAGS)  libarray.a array.o
	ranlib libarray.a
	
	$(AR) $(ARFLAGS)  libarray_debug.a array_debug.o
	ranlib libarray_debug.a

	$(AR) $(ARFLAGS)  liblinked_list.a linked_list.o
	ranlib liblinked_list.a

	$(AR) $(ARFLAGS)  liblist_debug.a list_debug.o
	ranlib liblist_debug.a

	$(AR) $(ARFLAGS)  liblist_int.a list_int.o
	ranlib liblist_debug.a

	$(AR) $(ARFLAGS)  liblist_int_deb.a list_int_deb.o
	ranlib liblist_debug.a

	$(AR) $(ARFLAGS)  libhash.a hash.o
	ranlib libhash.a

	$(AR) $(ARFLAGS)  libhash_debug.a hash_debug.o
	ranlib libhash_debug.a

	$(AR) $(ARFLAGS)  libhash_int.a hash_int.o
	ranlib libhash_debug.a

	$(AR) $(ARFLAGS)  libhash_int_deb.a hash_int_deb.o
	ranlib libhash_debug.a
	 
	\cp libNew.a libstack.a libarray.a liblinked_list.a libhash.a libstruct.a $(LIBRARIES)
	\cp *debug.a $(LIBRARIES)/debug
	\cp *int*.a $(LIBRARIES)/debug/internal
	chmod a+r $(LIBRARIES)/*
	chmod a+r $(LIBRARIES)/debug/*
	chmod a+r $(LIBRARIES)/debug/internal/*


clean:
	\rm -f *.o
	\rm -f *.a
	make

New.o:       
New_debug.o:   New.c
	$(CC) -o   New_debug.o -DSTRUCT_DEBUG  $(INCDIR) -g -c New.c

stack.o:       
stack_debug.o: stack.c
	$(CC) -o stack_debug.o -DSTRUCT_DEBUG  $(INCDIR) -g -c stack.c

array.o:       
array_debug.o: array.c 
	$(CC) -o array_debug.o -DSTRUCT_DEBUG  $(INCDIR) -g -c array.c

linked_list.o: 
list_debug.o:  linked_list.c
	$(CC) -o  list_debug.o -DSTRUCT_DEBUG  $(INCDIR) -g -c linked_list.c

hash.o:        
hash_debug.o:  hash.c
	$(CC) -o  hash_debug.o -DSTRUCT_DEBUG  $(INCDIR) -g -c hash.c

list_int.o:       linked_list.c
	$(CC) -o  list_int.o -D_LL_INTERNAL_DEBUG $(INCDIR) -g -c linked_list.c

hash_int.o:       hash.c
	$(CC) -o  hash_int.o -D_LL_INTERNAL_DEBUG $(INCDIR) -g -c hash.c

list_int_deb.o: linked_list.c
	$(CC) -o  list_int_deb.o -D_LL_INTERNAL_DEBUG   -DSTRUCT_DEBUG  $(INCDIR) -g -c linked_list.c

hash_int_deb.o: hash.c
	$(CC) -o  hash_int_deb.o -D_HASH_INTERNAL_DEBUG -DSTRUCT_DEBUG  $(INCDIR) -g -c hash.c

	



