/*-----------------------------------------------------------
 *  Name: 	array_ex.c
 *  Created:	Sat Oct  1 18:32:00 1994
 *  Author: 	Jonathan DeKock   <dekock@winter>
 *  DESCR:  	Example usse of the array.a library.
 */

#include <array.h>
#include <New.h>
#include <stdio.h>
#include <string.h>

typedef struct blee {
   char *name;
   int   val;
} BLEE;

#define SIZE 10
BLEE array[SIZE] = { /* Note: This is NOT an array op pointers */
   {"Joe",    0}, {"Frank",  1}, {"Buddy",  2}, {"Jim",    3}, {"George", 4},
   {"Jane",   5}, {"Jay",    6}, {"Laura",  7}, {"Craig",  8}, {"Bill",   9},
};

int Compare(BLEE *b1, BLEE *b2) { return(strcmp(b1->name, b2->name)); }
int Search (BLEE *b, char *key) { return(strcmp(b->name,  key));      }
int Find   (BLEE *b, char *key) { return(!strcmp(b->name, key));      }

main() {
   BLEE **a1 = NewArray(BLEE*, SIZE);
   BLEE **a2 = NewArray(BLEE*, SIZE);
   BLEE **a3 = NewArray(BLEE*, SIZE);
   BLEE *result;
   int i;

   for (i = 0; i < SIZE; i++) {
      a1[i] = &array[i]; a2[i] = &array[i]; a3[i] = &array[i];
   }

   result = ARRAY_Find(a1, SIZE, "Jay", Find);
   printf("Found %s with value %d.\n\n", result->name, result->val);

   ARRAY_BubbleSort(a1, SIZE, Compare);
   ARRAY_QuickSort (a2, SIZE, Compare);
   ARRAY_MergeSort (a3, SIZE, Compare);

   printf("\nArray #1\n");
   for (i = 0; i < SIZE; i++) printf("a1[%d] %-8s %d\n", i, a1[i]->name, a1[i]->val);
   printf("\nArray #2\n");
   for (i = 0; i < SIZE; i++) printf("a2[%d] %-8s %d\n", i, a2[i]->name, a2[i]->val);
   printf("\nArray #3\n");
   for (i = 0; i < SIZE; i++) printf("a3[%d] %-8s %d\n", i, a3[i]->name, a3[i]->val);
   
   printf("\n");
   ARRAY_BubbleSort(a1, SIZE, Compare);
   ARRAY_QuickSort (a2, SIZE, Compare);
   ARRAY_MergeSort (a3, SIZE, Compare);

   printf("\n");
   result = ARRAY_BinarySearch(a1, SIZE, "Jay", Search);
   printf("Binary Search returned %s, %d\n", result->name, result->val);

   Delete(a1); Delete(a2); Delete(a3);
}

   
