/*-----------------------------------------------------------
 *  Name: 	stack_ex.c
 *  Created:	Sat Oct  1 15:53:13 1994
 *  Author: 	Jonathan DeKock   <dekock@winter>
 *  DESCR:  	Example use of the stack.a library.
 */

#include <stack.h>
#include <math.h>    /* For sqrt() function, must link in "-lm" */
#include <stdio.h>

typedef void (*Proc)(int);
extern void SomeFunction(int);
extern void MyHandler(STACK*, enum STACK_ERROR, char*);

main() {
   STACK *s1 = Create_STACK(10);
   STACK *s2 = Create_STACK(2);
   STACK_ErrorProc old_handler;
   Proc   some_fn;
   double d;
   char   c;
   int    i;


   Set_STACK_Dynamic(s1, True);
   Set_STACK_Report(s1, True);  /* For output files                        */
   Set_STACK_Report(s2, True);
   
   for (i = 0; i < 20; i++) {
      Push(s1, i*(i+1));        /* Push a bunch of int's (dynamic stack)   */ 
   }

   Print_STACK(s1, NULL);

   Push(s2, SomeFunction);      /* Example pushing a function              */
   Push(s2, 'h');               /* Example pushing a char                  */

   Push(s2, 'a');               /* Attempt to push over top of s2          */
   
   old_handler = Set_STACK_Handler(MyHandler);
   Push(s2, 'b');               /* Attempt to push over top of s2          */

   Print_STACK(s2, NULL);
   c =       (char) Pop(s2);    /* Pop off the value 'h' into c            */
   some_fn = (Proc) Pop(s2);    /* Pop off the function into some_fn       */

   Pop(s2);                     /* Attempt to pop off under the bot. of s2 */

   Set_STACK_Handler(old_handler);

   Pop(s2);                     /* Attempt to pop off under the bot. of s2 */

   Destroy_STACK(s2);

   while (Get_STACK_Count(s1) > 0) { Pop(s1); } /* Clear stack s1          */

   d = sqrt(131);               /* Show how to push big items              */
   MultiPush(s1, d);
   Push(s1, 131);

   Print_STACK(s1, NULL);
   
   d = 0;

   i = (int) PopM(s1);          /* Fast macro expansion                    */
   MultiPop(s1, d);
   printf("I calculated sqrt(%d) pushed and poped and got %f\n", i, d);
   
   Destroy_STACK(s1);
}

void SomeFunction(int i) { printf("SomeFunction(%d)\n", i); }
void MyHandler(STACK *s, enum STACK_ERROR error_num, char *fn) {
   printf("My handler reports error #%d on stack 0x%.8x\n", error_num, s);
   printf("in function %s ==> \"%s\"\n", fn, STACK_errlist[error_num]);
}

