/*-----------------------------------------------------------
 *  Name: 	New_ex.c
 *  Created:	Wed Sep 28 20:34:11 1994
 *  Author: 	Jonathan DeKock   <dekock@winter>
 *  DESCR:  	Example use of the New.a library
 */

#include <New.h>
#include <stdio.h>

typedef struct blee {
   char *name;
   int   value;
} BLEE;

extern void MyHandler(unsigned size, char *name, char *file, int line);

main() {
   int           *a1, *a2;
   struct blee   *b1, *b2;
   New_ErrorProc  old_handler;
   
   a1 = New(int);
   a2 = NewArray(int, 100);
   b1 = New(struct blee);
   b2 = New(BLEE);

   Delete(b2);
   b2 = NewArray(BLEE, 100);
   
   Delete(a2);
   old_handler = Set_New_Handler(MyHandler);
   a2 = NewArray(int, 100000000);         /* Should fail, to big (MyHandler) */
   Set_New_Handler(old_handler);

   a2 = NewArray(int, 100000000);         /* Should fail, to big (Default)   */

   Delete(a1);
   a1 = NewArray(int, 250);
   
   b2 = ReallocateArray(b2, BLEE, 200);

   a2 = ReallocateArray(a2, int, 200);    /* Should fail, never alloc'd      */
   
   Delete(a1);
   Delete(a2);                            /* Should fail, never alloc'd      */
   Delete(b1);
   Delete(b2);

}

void MyHandler(unsigned size, char *name, char *file, int line) {
   printf("New reports error #%d \"%s\" while allocating %u bytes.\n",
	  errno, sys_errlist[errno], size);
   if (name) printf("Attempt to allocate a \"%s\". (file = %s, line = %d)\n",
		    name, file, line);
}

