##
## Makfile for all examples
##
STRUCT_DIR=$(HOME)/struct

EXECS=New_ex stack_ex array_ex list_ex1 list_ex2 hash_ex1 hash_ex2

INCDIR=-I$(STRUCT_DIR)/include

CC=gcc

## Optimized output
##LIBDIR=-L$(STRUCT_DIR)/lib
##LIBS=-lstruct
##CFLAGS=-g

## Alternate Debug information
LIBDIR=-L$(STRUCT_DIR)/lib/debug -L$(STRUCT_DIR)/lib
LIBS=-lhash_debug -llist_debug -larray_debug -lstack -lNew
CFLAGS=-g -DSTRUCT_DEBUG

all: $(EXECS)

clean:
	\rm -f *.o
	\rm -f $(EXECS)

## Exec's

New_ex:   New_ex.o
	$(CC) -o New_ex   New_ex.o   $(LIBDIR) $(LIBS)

stack_ex: stack_ex.o
	$(CC) -o stack_ex stack_ex.o $(LIBDIR) $(LIBS)

array_ex: array_ex.o
	$(CC) -o array_ex array_ex.o $(LIBDIR) $(LIBS)

list_ex1: list_ex1.o
	$(CC) -o list_ex1 list_ex1.o $(LIBDIR) $(LIBS)

list_ex2: list_ex2.o
	$(CC) -o list_ex2 list_ex2.o $(LIBDIR) $(LIBS)

hash_ex1: hash_ex1.o
	$(CC) -o hash_ex1 hash_ex1.o $(LIBDIR) $(LIBS)

hash_ex2: hash_ex2.o
	$(CC) -o hash_ex2 hash_ex2.o $(LIBDIR) $(LIBS)


## Obj's

New_ex.o:   New_ex.c
	$(CC) $(CFLAGS) $(INCDIR) -c New_ex.c

stack_ex.o: stack_ex.c
	$(CC) $(CFLAGS) $(INCDIR) -c stack_ex.c

array_ex.o: array_ex.c
	$(CC) $(CFLAGS) $(INCDIR) -c array_ex.c

list_ex1.o: list_ex1.c
	$(CC) $(CFLAGS) $(INCDIR) -c list_ex1.c

list_ex2.o: list_ex2.c
	$(CC) $(CFLAGS) $(INCDIR) -c list_ex2.c

hash_ex1.o: hash_ex1.c
	$(CC) $(CFLAGS) $(INCDIR) -c hash_ex1.c

hash_ex2.o: hash_ex2.c
	$(CC) $(CFLAGS) $(INCDIR) -c hash_ex2.c



