/* pcp from SUT, in MPI */
#include "mpi.h"
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#define BUFSIZE    256*1024
#define CMDSIZE    80
int main( int argc, char *argv[] )
{
    int mystatus, allstatus, done, numread;
    char outfilename[128], controlmsg[80];
    int infd, outfd;
    char buf[BUFSIZE];
    MPI_Init( &argc, &argv );

    makehostlist( argv[1], "targets" );
    strcpy( outfilename, argv[3] );
    if ( (infd = open( argv[2], O_RDONLY ) ) == -1 ) {
        fprintf( stderr, "input file %s does not exist\n", argv[2] ); 
	sprintf( controlmsg, "exit" );
	MPI_Bcast( controlmsg, CMDSIZE, MPI_CHAR, 0, MPI_COMM_WORLD );
	MPI_Finalize();
	return( -1 );
    }
    else {
        sprintf( controlmsg, "ready" );
        MPI_Bcast( controlmsg, CMDSIZE, MPI_CHAR, 0, MPI_COMM_WORLD );
    }

    sprintf( controlmsg, outfilename );
    MPI_Bcast( controlmsg, CMDSIZE, MPI_CHAR, 0, MPI_COMM_WORLD );
    if ( (outfd = open( outfilename, O_CREAT|O_WRONLY|O_TRUNC, S_IRWXU ) ) == -1 ) 
        mystatus = -1;
    else
        mystatus = 0;
    MPI_Allreduce( &mystatus, &allstatus, 1, MPI_INT, MPI_MIN,
		   MPI_COMM_WORLD );
    if ( allstatus == -1 ) {
        fprintf( stderr, "output file %s could not be opened\n", outfilename );
	MPI_Finalize();
	return( -1 );
    }

    /* at this point all files have been successfully opened */
    
    done = 0;
    while ( !done ) {
        numread = read( infd, buf, BUFSIZE );
	MPI_Bcast( &numread, 1, MPI_INT, 0, MPI_COMM_WORLD );
	if ( numread > 0 ) {
	    MPI_Bcast( buf, numread, MPI_BYTE, 0, MPI_COMM_WORLD );
	    write( outfd, buf, numread );
	}
	else {	  
	    close( outfd );
	    done = 1;
	}
    }
    MPI_Finalize();
}

int makehostlist( char spec[80], char filename[80] )
{

}
