#include "list.h"

extern char *DupString( const char * );

void InsertElm( const char *key, const char *value )
{
    ListElm *ptr, *last_ptr, *new_ptr;
    int     compare;
    
    /* Lock list, find insertion point, and insert element */
    lock_mutex();
    
    last_ptr = head;
    ptr      = head->next;
    while (ptr) {
	compare = strcmp( ptr->key, key );
	if (compare == 0) {
	    /* Duplicate key. Ignore */
	    unlock_mutex(); return; }
	if (compare > 0) {
	    break;
	}
	last_ptr = ptr;
	ptr      = ptr->next;
    }
    
    /* Create new element */
    if ( !(new_ptr = (ListElm *)malloc( sizeof(ListElm) )) )
        abort();
    new_ptr->key   = DupString( key );
    new_ptr->value = DupString( value );
    new_ptr->next  = ptr;
    last_ptr->next = new_ptr;

    unlock_mutex();
}
