extern int MPE_COUNTER_KEYVAL;

void MPE_Counter_create( MPI_Comm old_comm, MPI_Win *counter_win )
{
    int size, rank, *counter_mem, i, *myval_p;

    MPI_Comm_rank(old_comm, &rank);
    MPI_Comm_size(old_comm, &size);

    if (rank == 0) {
	MPI_Alloc_mem( size * sizeof(int), MPI_INFO_NULL, 
                       &counter_mem );
	for (i=0; i<size; i++) counter_mem[i] = 0;
	MPI_Win_create( counter_mem, size * sizeof(int), sizeof(int), 
			MPI_INFO_NULL, old_comm, counter_win );
	
    }
    else {
	MPI_Win_create( NULL, 0, 1, MPI_INFO_NULL, old_comm, 
			counter_win );
    }
    /* Create my local counter */
    if (MPE_COUNTER_KEYVAL == MPI_KEYVAL_INVALID) {
	MPI_Win_create_keyval( MPI_WIN_NULL_COPY_FN, 
                               MPI_WIN_NULL_DELETE_FN,
			       &MPE_COUNTER_KEYVAL, NULL );
    }
    myval_p = (int *)malloc( sizeof(int) );
    MPI_Win_set_attr( *counter_win, MPE_COUNTER_KEYVAL, myval_p );
}
