void MPE_Counter_free( MPI_Win *counter_win )
{
    int counter_flag, *counter_mem, flag, *myval_p;

    MPI_Win_get_attr( *counter_win, MPI_WIN_BASE, 
		      &counter_mem, &counter_flag );
    MPI_Win_get_attr( *counter_win, MPE_COUNTER_KEYVAL, 
                      &myval_p, &flag );
    
    /* Free is collective and will not return until all proceeses 
       have called it */
    MPI_Win_free( counter_win );

    /* Free the memory used by the counter and local value */
    if (counter_flag && counter_mem) 
	MPI_Free_mem( counter_mem );
    free( myval_p );
}
