#include "ga.h"
int ga_read_inc( GA ga, int i, int j, int inc )
{
    int buf, rank;
    MPI_Aint disp;

    rank   = (j - 1) / ga->chunk2;
  
    /* disp depends on the displacement unit being sizeof(int) */
    disp = (j - 1 - (rank * ga->chunk2)) * ga->dim1 + i - 1;

    MPE_Mutex_lock( rank, ga->lock_win );
  
    MPI_Win_lock( MPI_LOCK_SHARED, rank, MPI_MODE_NOCHECK,
		  ga->ga_win );
    MPI_Get( &buf, 1, MPI_INT, disp, 1, MPI_INT, rank, ga->ga_win );
    MPI_Win_unlock( rank, ga->ga_win );

    MPI_Win_lock( MPI_LOCK_SHARED, rank, MPI_MODE_NOCHECK,
		  ga->ga_win );
    MPI_Accumulate( &inc, 1, MPI_INT, 
		    disp, 1, MPI_INT, rank, MPI_SUM, ga->ga_win );
    MPI_Win_unlock( rank, ga->ga_win );

    MPE_Mutex_unlock( rank, ga->lock_win );

    return buf;
}
