#include "ga.h"
int ga_create( MPI_Comm comm, int dim1, int dim2, 
               MPI_Datatype dtype, GA *ga )
{
    GA       new_ga;
    int      size, chunk2, sizeoftype;
    MPI_Aint local_size;
    void     *ga_win_ptr;

    /* Get a new structure */
    new_ga = (GA)malloc( sizeof(struct _GA) );  
    if (!new_ga) return 0;

    /* Determine size of GA memory */
    MPI_Comm_size( comm, &size );
    chunk2 = dim2 / size;
    /* Require size to exactly divide dim2 */
    if ((dim2 % size) != 0) MPI_Abort( comm, 1 );
    MPI_Type_size( dtype, &sizeoftype );
    local_size = dim1 * chunk2 * sizeoftype;

    /* Allocate memory my ga_win and create window */
    MPI_Alloc_mem( local_size, MPI_INFO_NULL, &ga_win_ptr );
    
    MPI_Win_create( ga_win_ptr, local_size, sizeoftype, 
                    MPI_INFO_NULL, comm, &new_ga->ga_win );

    /* Create critical section window */
    MPE_Mutex_create( comm, size, &new_ga->lock_win );

    /* Save other data and return */
    new_ga->dtype      = dtype;
    new_ga->dtype_size = sizeoftype;
    new_ga->dim1       = dim1;
    new_ga->dim2       = dim2;
    new_ga->chunk2     = chunk2;
    *ga                = new_ga;

    return 1;
}
