#include "Dlist.h"
extern char *DupString( const char * );
extern MPI_Win winlock;

char *FindElm( MPI_Win win, const char *key )
{
    ListElm        local_copy, *local_copy_ptr;
    char           *local_value = 0;
    RemotePointer  ptr;
    int            my_rank;
    MPI_Group      win_group;

    /* my_rank could also be precomputed, of course */
    MPI_Win_get_group( win, &win_group );
    MPI_Group_rank( win_group, &my_rank );
    MPI_Group_free( &win_group );

    MPE_Mutex_lock( 0, winlock );
    ptr = head;

    while (ptr.owner_rank >= 0) {
	/* Make sure we have the data */
	MPI_Win_lock( MPI_LOCK_SHARED, ptr.owner_rank, 
		      MPI_MODE_NOCHECK, win );
	if (ptr.owner_rank != my_rank) {
	    MPI_Get( &local_copy, 1, ListElm_type, 
		     ptr.owner_rank, ptr.disp, 1, ListElm_type, win );
	    local_copy_ptr = &local_copy;
	}
	else 
	    local_copy_ptr = (ListElm *)(ptr.local_pointer);
	MPI_Win_unlock( ptr.owner_rank, win );

	if (strcmp( local_copy_ptr->key, key ) == 0) {
	    local_value = DupString( local_copy_ptr->value );
	    break;
	}
	ptr = local_copy_ptr->next;
    }
    MPE_Mutex_unlock( 0, winlock );
    return local_value;
}
