#include "Dlist.h"

char *FindElm( MPI_Win win, const char *key )
{
    static ListElm local_copy;
    ListElm        *local_copy_ptr;
    RemotePointer  ptr;
    int            my_rank;
    MPI_Group      win_group;

    /* my_rank could also be precomputed, of course */
    MPI_Win_get_group( win, &win_group );
    MPI_Group_rank( win_group, &my_rank );
    MPI_Group_free( &win_group );

    ptr = head;
    while (ptr.owner_rank >= 0) {
	/* Make sure we have the data */
	if (ptr.owner_rank != my_rank) {
	    MPI_Win_lock( MPI_LOCK_SHARED, ptr.owner_rank, 0, win );
	    MPI_Get( &local_copy, 1, ListElm_type, 
		     ptr.owner_rank, ptr.disp, 1, ListElm_type, win );
	    MPI_Win_unlock( ptr.owner_rank, win );
	    local_copy_ptr = &local_copy;
        }
	else 
	    local_copy_ptr = (ListElm *)(ptr.local_pointer);
	
	if (strcmp( local_copy_ptr->key, key ) == 0) 
	    return local_copy_ptr->value;
	ptr = local_copy_ptr->next;
    }
    /* Did not find key */
    return 0;
}
