      subroutine rmasetup( a, sx, ex, sy, ey, win )

      integer win, sizedouble, ierr
      integer (kind=MPI_ADDRESS_KIND) right_ghost_disp, 
     *     left_ghost_disp, top_ghost_disp
      integer my_right_ghost_disp, my_left_ghost_disp, 
     *     my_top_ghost_disp, right_ghost_disp_int, 
     *     left_ghost_disp_int, top_ghost_disp_int
      double precision a(sx-1:ex+1,sy-1:ey+1)

C nx is the number of (non-ghost) values in x, ny in y
      nx = ex - sx + 1
      ny = ey - sy + 1
      call MPI_TYPE_SIZE( MPI_DOUBLE_PRECISION, sizedouble, ierr )
      call MPI_WIN_CREATE( a, (ex-sx+3)*(ey-sy+3)*sizedouble, 
     *     sizedouble, MPI_INFO_NULL, MPI_COMM_WORLD, 
     *     win, ierr )
C Exchange information on the offsets
C Compute the displacement into my right ghost cells
      my_right_ghost_disp = 2*(nx+2)-1
      call MPI_SEND( my_right_ghost_disp, 1, MPI_INTEGER, right_nbr, 
     *     0, MPI_COMM_WORLD, ierr )
      call MPI_RECV( right_ghost_disp_int, 1, MPI_INTEGER, left_nbr, 
     *     0, MPI_COMM_WORLD, status, ierr )
C! Compute the displacement into my top ghost cells
      my_top_ghost_disp = (nx + 2)*(ny + 1) + 1
      call MPI_SEND( my_top_ghost_disp, 1, MPI_INTEGER, top_nbr, 
     *     0, MPI_COMM_WORLD, ierr )
      call MPI_RECV( top_ghost_disp_int, 1, MPI_INTEGER, bottom_nbr, 
     *     0, MPI_COMM_WORLD, status, ierr )
C Compute the displacement into my left ghost cells
      my_left_ghost_disp = nx + 2
      call MPI_SEND( my_left_ghost_disp, 1, MPI_INTEGER, left_nbr, 
     *     0, MPI_COMM_WORLD, ierr )
      call MPI_RECV( left_ghost_disp_int, 1, MPI_INTEGER, right_nbr, 
     *     0, MPI_COMM_WORLD, status, ierr )
C Just in case INTEGER is not the same as MPI_ADDRESS_KIND integer
      right_ghost_disp  = right_ghost_disp_int
      top_ghost_disp    = top_ghost_disp_int
      left_ghost_disp   = left_ghost_disp_int

      return 
      end
