      subroutine exchng2( a, sx, ex, sy, ey, win, 
     *   left_nbr, right_nbr, top_nbr, bot_nbr, 
     *   right_ghost_disp, left_ghost_disp, 
     *   top_ghost_disp, coltype, right_coltype, left_coltype )
      include 'mpif.h'
      integer sx, ex, sy, ey, win, ierr
      integer left_nbr, right_nbr, top_nbr, bot_nbr
      integer coltype, right_coltype, left_coltype
      double precision a(sx-1:ex+1,sy-1:ey+1)
C     This assumes that an address fits in a Fortran integer.
C     Change this to integer*8 if you need 8-byte addresses
      integer (kind=MPI_ADDRESS_KIND) right_ghost_disp, 
     *    left_ghost_disp, top_ghost_disp, bot_ghost_disp
      integer nx
      
      nx = ex - sx + 1
      
      call MPI_WIN_FENCE( 0, win, ierr )
C Put bottom edge into bottom neighbor's top ghost cells
      call MPI_PUT( a(sx,sy), nx, MPI_DOUBLE_PRECISION, bot_nbr, 
     *      top_ghost_disp, nx, MPI_DOUBLE_PRECISION, 
     *      win, ierr )
C Put top edge into top neighbor's bottom ghost cells
      bot_ghost_disp = 1
      call MPI_PUT( a(sx,ey), nx, MPI_DOUBLE_PRECISION, top_nbr, 
     *      bot_ghost_disp, nx, MPI_DOUBLE_PRECISION, 
     *      win, ierr )
C Put right edge into right neighbor's left ghost cells
      call MPI_PUT( a(ex,sy), 1, coltype, 
     *      right_nbr, left_ghost_disp, 1, right_coltype, 
     *      win, ierr )
C Put left edge into the left neighbor's right ghost cells
      call MPI_PUT( a(sx,sy), 1, coltype, 
     *      left_nbr, right_ghost_disp, 1, left_coltype, 
     *      win, ierr )
      call MPI_WIN_FENCE( 0, win, ierr )
      return
      end
