#include "mpi.h"

void mpi_file_write_(MPI_Fint *fh, void *buf, int *count,
		     MPI_Fint *datatype, MPI_Fint *status, 
		     MPI_Fint *err)
{
    MPI_File fh_c;
    MPI_Datatype datatype_c;
    MPI_Status status_c;
    
    fh_c = MPI_File_f2c(*fh);
    datatype_c = MPI_Type_f2c(*datatype);
    *err = (MPI_Fint) MPI_File_write(fh_c, buf, *count, datatype_c,
				     &status_c);
    MPI_Status_c2f(&status_c, status);
}
