void *write_thread(void *ptr)
{
    params_struct *params;

    params = (params_struct *) ptr;
    MPI_File_write(params->fh, params->buf, params->count, 
		   *(params->datatype), params->status);
    MPI_Grequest_complete(*(params->request));
    return 0;
}

int query_fn(void *extra_state, MPI_Status *status)
{
    params_struct *params;
    int count;

    params = (params_struct *) extra_state;
    MPI_Get_elements(params->status, *(params->datatype), &count);
    MPI_Status_set_elements(status, *(params->datatype), count);
    MPI_Status_set_cancelled(status, 0);
    return MPI_SUCCESS;
}

int free_fn(void *extra_state)
{
    free(((params_struct *) extra_state)->status);
    MPI_Type_free(((params_struct *) extra_state)->datatype);
    free(extra_state);
    return MPI_SUCCESS;
}

int cancel_fn(void *extra_state, int complete)
{
    return MPI_SUCCESS;
}
